% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{solveSmoothedLASSO}
\alias{solveSmoothedLASSO}
\title{Minimize the smoothed LASSO objective function with respect to \eqn{\beta} using BFGS.}
\usage{
solveSmoothedLASSO(X, y, lambda, mu, entropy = T)
}
\arguments{
\item{X}{The data matrix of dimensions \eqn{n \times p}.}

\item{y}{The \eqn{n}-vector of responses.}

\item{lambda}{The LASSO regularization parameter.}

\item{mu}{The Nesterov smoothing parameter.}

\item{entropy}{A boolean switch to select the entropy prox function (default) or the squared error prox function.}
}
\value{
The LASSO estimator \eqn{\beta}.
}
\description{
Minimize the smoothed LASSO objective function with respect to \eqn{\beta} using BFGS.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
beta <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% beta
lambda <- 1
print(solveSmoothedLASSO(X,y,lambda,mu=0.1))

}
