% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_forest_annot.R
\name{sm_forest_annot}
\alias{sm_forest_annot}
\title{Annotation of the error range on the forest plot}
\usage{
sm_forest_annot(
  data,
  x,
  y,
  errorbar_type = "ci",
  text.params = list(size = 4, color = "black"),
  sep_level = 2,
  ...
)
}
\arguments{
\item{data}{Data frame variable that is used for plotting.}

\item{x}{Column of the data frame that represents the x-axis.}

\item{y}{Column of the data frame that represents the y-axis.}

\item{errorbar_type}{This argument determines the errorbar type.
If it is set to 'se', standard error bar will be shown.
If it is set to 'sd' (default), the error bar will display standard deviation.
If it is set to 'ci', the error bar will display 95\% confidence interval.}

\item{text.params}{List of parameters for the text annotation, such as color, size etc}

\item{sep_level}{A numerical value that controls the level of the separation between
the text annotation and the average point.
If it's 0, all of these are clustered together. If it's higher (and more positive),
the text annotations will increasingly go above the mean point. Default is set to 2. The values
can be negative so that the texts can be below the mean point. There is no limit of
the range for this argument. Ideally, this should equal to the sep_level in sm_forest().}

\item{...}{Parameters for the text annotation, such as size and color etc.}
}
\value{
Annotations showing the range of uncertainty will printed
on the forest plot.
}
\description{
Annotation of the error range on the forest plot
}
\examples{
library(ggplot2)
library(smplot2)

day1 = rnorm(20,0,1)
day2 = rnorm(20,5,1)
day3 = rnorm(20,6,1.5)
day4 = rnorm(20,7,2)
Subject <- rep(paste0('S',seq(1:20)), 4)
Data <- data.frame(Value = matrix(c(day1,day2,day3,day4),ncol=1))
Day <- rep(c('Day 1', 'Day 2', 'Day 3', 'Day 4'), each = length(day1))
df2 <- cbind(Subject, Data, Day)

ggplot(data = df2, aes(x = Value, y = Day, color = Day)) +
 sm_forest(point_jitter_width = 0.12, sep_level = 3) +
 scale_color_manual(values = sm_palette(4)) +
 sm_forest_annot(data = df2, x = Value, y = Day, sep_level = 3)
}
