% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BparametersEst.R
\name{BparametersEst}
\alias{BparametersEst}
\title{Summary of the Bootstrap Degree Distribution}
\usage{
BparametersEst(outBootdeg)
}
\arguments{
\item{outBootdeg}{A list that is the output of \code{\link{bootdeg}}}
}
\value{
A list consisting of:
   \item{mean}{An array of dimension \code{length(outBootdeg$num.sam) x
         outBootdeg$n.boot x 3}. The last dimension, of 3, is for the three
         different methods of obtaining the empirical degree distribution
         from \code{outBootdeg$empd}
         (see output empd from \code{\link{bootdeg}} for details).
         The (i,j,k)-th element in the array is an estimate of mean degree for the
         i-th LSMI sample, j-th bootstrap replication, and k-th empirical distribution
         from \code{outBootdeg$empd}.}
   \item{quartiles}{An array of dimension \code{length(outBootdeg$num.sam) x 3 x
         outBootdeg$n.boot x 3}. The last dimension, of 3, is for the three
         different methods of estimation from \code{outBootdeg$empd}
         (see output empd from \code{\link{bootdeg}} for details). The second
         dimension, of 3, corresponds to the quartiles (.25, .5, .75).
         The (i,j,k,l)-th element in the array is an estimate of j-th
         quartile for the i-th LSMI sample, k-th bootstrap replication,
         and l-th empirical distribution from \code{outBootdeg$empd}.}
   \item{rfreq}{An array of dimension \code{length(outBootdeg$num.sam) x 5 x
         outBootdeg$n.boot x 3}. The last dimension, of 3, is for the three
         different methods of estimation from \code{outBootdeg$empd}
         (see output empd from \code{\link{bootdeg}} for details.). The second
         dimension, of 5, corresponds to degree values: 0, 1, 2, 3, 4.
         The (i,j,k,l)-th element in the array is the proportion of nodes
         with degree j in the i-th LSMI sample, k-th bootstrap replication,
         and l-th empirical distribution from \code{outBootdeg$empd}.}
   \item{deciles}{An array of dimension \code{length(outBootdeg$num.sam) x 9 x
         outBootdeg$n.boot x 3}. The last dimension, of 3, is for the three
         different methods of estimation from \code{outBootdeg$empd}
         (see output empd from \code{\link{bootdeg}} for details.). The second
         dimension, of 9, corresponds to the deciles (.1, .2, ... , .9).
         The (i,j,k,l)-th element in the array is an estimate of j-th
         decile for the i-th LSMI sample, k-th bootstrap replication,
         and l-th empirical distribution from \code{outBootdeg$empd}.}
   \item{num.sam}{Numeric indices corresponding to LSMI samples used for bootstrap.
         See value \code{num.sam} from \code{\link{bootdeg}}}
   \item{seeds1}{A matrix of dimension \code{length(num.sam)} x \code{n.seeds} with
         the numeric seed ids. Each row corresponds to one LSMI. The rows are
         present in the same order as the ids in \code{num.sam}.
         See value \code{seeds1} from \code{\link{bootdeg}}}
   \item{nodes_of_LSMI}{A list of length \code{length(num.sam)} where each
         element is vector containing the numeric ids of the nodes sampled
         using the respective LSMI. The elements are present in the same
         order as the ids in \code{num.sam}.
         Note: nodes_of_LSMI is unreported when n.neigh equals zero.
         See value \code{nodes_of_LSMI} from \code{\link{bootdeg}}}
}
\description{
This function provides summary statistics of a bootstrap degree
distribution.
}
\examples{
net <- artificial_networks[[1]]
sam.out <- Oempdegreedistrib(net = net, n.seeds = 40, n.neigh = 1, num.sam = 1)
outBootdeg <- bootdeg(sam.out = sam.out, n.boot = 50)
a <- BparametersEst(outBootdeg)
}
\references{
Efron, B. (1979). Bootstrap methods: another look at the
 jackknife. The annals of Statistics, 1-26.

Thompson, M. E., Ramirez Ramirez, L. L., Lyubchich, V. and
 Gel, Y. R. (2015), Using the bootstrap for statistical inference
 on random graphs. Can J Statistics. doi: 10.1002/cjs.11271
}

