% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R, R/get_solution.R
\name{ZB18a}
\alias{ZB18a}
\alias{get_ZB18a}
\title{Orbital Solution ZB18a}
\format{
\subsection{\code{ZB18a}}{

A data frame with 250,001 rows and 20 columns:
\describe{
\item{t}{Time \eqn{t} (days).}
\item{age}{Age in thousands of years before present (ka).}
\item{aa}{Semimajor axis \eqn{a} in astronomical units (au).}
\item{ee}{Eccentricity \eqn{e} (unitless).}
\item{inc}{Inclination \eqn{I} (degrees).}
\item{lph}{Longitude of perihelion \eqn{\varpi} (degrees).}
\item{lan}{Longitude of the ascending node \eqn{\Omega} (degrees).}
\item{arp}{Argument of perihelion \eqn{\omega} (degrees).}
\item{mna}{Mean anomaly \eqn{M} (degrees).}

The following columns were computed from the above input:

\item{lphu}{Unwrapped longitude of perihelion \eqn{\varpi} (degrees without
jumps).}

\item{lanu}{Unwrapped longitude of the ascending node \eqn{\Omega}
(degrees without jumps).}

\item{hh}{Variable: \eqn{e\sin(\varpi)}{ee * sin(lph / R2D)}.}

\item{kk}{Variable: \eqn{e\cos(\varpi)}{ee * cos(lph / R2D)}.}

\item{pp}{Variable: \eqn{2\sin(0.5I)\sin(\Omega)}{2 * sin(0.5 * inc / R2D) *
  sin(lan / R2D)}.}

\item{qq}{Variable: \eqn{2\sin(0.5I)\cos(\Omega)}{2 * sin(0.5 * inc / R2D) *
  cos(lan / R2D)}.}

\item{cc}{Helper: \eqn{\cos(I)}{cos(inc / R2D)}.}

\item{dd}{Helper: \eqn{\cos(I)/2}{cos(inc / R2D / 2)}.}

\item{nnx, nny, nnz}{The \eqn{x}, \eqn{y}, and \eqn{z}-components of the
Eart's orbit unit normal vector \eqn{\vec{n}}{n}, normal to Earth's
instantaneous orbital plane.}

}
}
}
\source{
\itemize{
\item All orbital solutions by Zeebe can be found on
\url{http://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}.
\item The specific one we use here is available at
\url{http://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro/PrecTilt/OS/ZB18a/ems-plan3.dat}.
}
}
\usage{
get_ZB18a(quiet = FALSE, force = FALSE)
}
\arguments{
\item{quiet}{Be quiet?
\itemize{
\item If \code{TRUE}, hide info messages.
\item If \code{FALSE} (the default) print info messages and timing.
}}

\item{force}{Force re-downloading the results, even if the solution is saved
to the cache.}
}
\value{
\code{get_ZB18a()} returns a \link[tibble:tibble-package]{tibble} with the
orbital solution input and some preprocessed new columns.
}
\description{
The HNBody output of Zeebe & Lourens (2019).
}
\details{
The wikipedia page on \href{https://en.wikipedia.org/wiki/Orbital_elements}{Orbital elements} describes what the
components relate to in order to uniquely specify an orbital plane. The
function asks to download the files to the user's cache directory so that they
can be accessed more quickly in the future.
}
\examples{
\donttest{
get_ZB18a()
}
}
\references{
Zeebe, R. E., & Lourens, L. J. (2019). Solar System chaos and the
Paleocene–Eocene boundary age constrained by geology and astronomy.
\emph{Science}, 365(6456), 926–929. \doi{10.1126/science.aax0612}.
}
\seealso{
\code{\link[=prepare_solution]{prepare_solution()}} Processes orbital solution input to include
helper columns.
}
