% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/banzhaf.R
\name{ordinalBanzhafScores}
\alias{ordinalBanzhafScores}
\alias{ordinalBanzhafRanking}
\title{Ordinal Banzhaf}
\usage{
ordinalBanzhafScores(powerRelation)

ordinalBanzhafRanking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}
}
\value{
Score function returns list of class type \code{OrdinalBanzhafScores} and length of \code{powerRelation$elements}.
Each index contains a vector of two numbers, the number of positive and the number of negative marginal contributions.
Those two numbers summed together gives us the actual ordinal Banzhaf score.

Ranking function returns corresponding \code{\link{SocialRankingSolution}} object.
}
\description{
Calculate the Ordinal Banzhaf scores, the number of
positive and negative marginal contributions.

\code{\link[=ordinalBanzhafRanking]{ordinalBanzhafRanking()}} returns the corresponding ranking.
}
\details{
\loadmathjax
Inspired by the Banzhaf index \insertCite{1964Banzhaf}{socialranking}, the Ordinal Banzhaf
determines the score of element \mjseqn{i} by adding the amount of coalitions
\mjeqn{S \subseteq N \setminus \lbrace i \rbrace}{S \\subseteq N \\ \{i\}}
its contribution impacts positively (\mjeqn{S \cup \lbrace i \rbrace \succ S}{S u \{i\} > S })
and subtracting the amount of coalitions where its contribution
had a negative impact (\mjeqn{S \succ S \cup \lbrace i \rbrace}{S > S u \{i\}})\insertCite{2019OrdinalBanzhaf}{socialranking}.
}
\examples{
# 12 > (2 ~ {}) > 1
pr <- newPowerRelation(c(1,2), ">", 2, "~", c(), ">", 1)

# Player 1 contributes positively to {2}
# Player 1 contributes negatively to {empty set}
# Therefore player 1 has a score of 1 - 1 = 0
#
# Player 2 contributes positively to {1}
# Player 2 does NOT have an impact on {empty set}
# Therefore player 2 has a score of 1 - 0 = 0
# `1` = c(1, -1)
# `2` = c(1, 0)
ordinalBanzhafScores(pr)

# 1 > 2
ordinalBanzhafRanking(pr)

}
\references{
\insertRef{2019OrdinalBanzhaf}{socialranking}

\insertRef{1964Banzhaf}{socialranking}
}
\seealso{
Other score vector functions: 
\code{\link{copelandScores}()},
\code{\link{cumulativeScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{lexcelScores}()}
}
\concept{score vector functions}
