% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePowerRelationMonotonic.R
\name{makePowerRelationMonotonic}
\alias{makePowerRelationMonotonic}
\title{Make Power Relation monotonic}
\usage{
makePowerRelationMonotonic(powerRelation, addMissingCoalitions = TRUE)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{addMissingCoalitions}{If \code{TRUE}, also include all coalitions in the power set of \code{powerRelation$elements} that are not present in the current power relation.}
}
\value{
\code{\link{PowerRelation}} object containing the following values:
\itemize{
\item \verb{$elements}: vector of elements
\item \verb{$eqs}: equivalence classes. Nested list of lists, each containing vectors representing groups of elements in the same equivalence class
\item \verb{$coalitionLookup}: \verb{function(v)} taking a coalition vector \code{v} and returning the equivalence class it belongs to. See \code{\link[=coalitionLookup]{coalitionLookup()}} for more.
\item \verb{$elementLookup}: \verb{function(e)} taking an element \code{e} and returning a list of 2-sized tuples. See \code{\link[=elementLookup]{elementLookup()}} for more.
}
}
\description{
Given a \code{powerRelation} object, make its order monotonic.
}
\details{
A power relation is monotonic if

\deqn{T \subset S \Leftrightarrow S \succsim T.}{T subset of S <=> S >= T.}

for every coalition \eqn{S \subseteq N}{S subset of N}.

Calling \code{makePowerRelationMonotonic()} on some \code{\link{PowerRelation}} object moves or adds coalitions to certain equivalence classes
so that the power relation becomes monotonic.
}
\examples{
pr <- as.PowerRelation("ab > ac > abc > b > a > {} > c > bc")
makePowerRelationMonotonic(pr)
# (abc ~ ab) > ac > (bc ~ b) > a > (c ~ {})

# notice that missing coalitions are automatically added,
# except for the empty set
pr <- as.PowerRelation("a > b > c")
makePowerRelationMonotonic(pr)
# (abc ~ ab ~ ac ~ a) > (bc ~ b) > c

# setting addMissingCoalitions to FALSE changes this behavior
pr <- as.PowerRelation("a > ab > c ~ {} > b")
makePowerRelationMonotonic(pr, addMissingCoalitions = FALSE)
# (ab ~ a) > (b ~ c ~ {})

# notice that an equivalence class containing an empty coalition
# automatically moves all remaining coalitions to that equivalence class.
pr <- as.PowerRelation("a > {} > b > c")
makePowerRelationMonotonic(pr)
# (abc ~ ab ~ ac ~ a) > (bc ~ b ~ c ~ {})

}
\seealso{
Other helper functions for transforming power relations: 
\code{\link{appendMissingCoalitions}()}
}
\concept{helper functions for transforming power relations}
