% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatures.R
\name{Signatures}
\alias{Signatures}
\alias{sig_sign}
\alias{sig}
\alias{sig_verify}
\alias{sig_keygen}
\alias{sig_pubkey}
\title{Create and Verify Signatures}
\usage{
sig_sign(msg, key)

sig_verify(msg, sig, pubkey)

sig_keygen(seed = random(32))

sig_pubkey(key)
}
\arguments{
\item{msg}{message to sign}

\item{key}{private key to sign message with}

\item{sig}{a signature generated by \code{signature_sign}}

\item{pubkey}{a public key of the keypair used by the signature}

\item{seed}{random data to seed the keygen}
}
\description{
Cryptographic signatures can be used to verify the integrity of a message using
the author's public key.
}
\details{
A signature is an authenticated checksum that can be used to check that a message
(any data) was created by a particular author and was not tampered with. The signature is
created using a private key and can be verified from the corresponding public key.

Signatures are used when the message itself is not confidential but integrity is
important. A common use is for software repositories where maintainers include
a signature of the package index. This allows client package managers to verify
that the binaries were not modified by intermediate parties in the distribution
process.

For confidential data, use authenticated encryption (\link{auth_encrypt})
which allows for sending signed and encrypted messages in a single method.

Currently sodium requires a different type of key pairfor signatures  (ed25519)
than for encryption (curve25519).
}
\examples{
# Generate keypair
key <- sig_keygen()
pubkey <- sig_pubkey(key)

# Create signature
msg <- serialize(iris, NULL)
sig <- sig_sign(msg, key)
sig_verify(msg, sig, pubkey)
}
\references{
\url{http://doc.libsodium.org/public-key_cryptography/public-key_signatures.html}
}
