% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapunit_geom_by_ll_bbox.R
\name{mapunit_geom_by_ll_bbox}
\alias{mapunit_geom_by_ll_bbox}
\title{Fetch Map Unit Geometry from SDA}
\usage{
mapunit_geom_by_ll_bbox(bbox, source = "sda")
}
\arguments{
\item{bbox}{a bounding box in WGS coordinates}

\item{source}{the source database, currently limited to soil data access (SDA)}
}
\value{
A SpatialPolygonsDataFrame of map unit polygons, in WGS84 (long,lat) coordinates.
}
\description{
Fetch map unit geometry from the SDA website by WGS84 bounding box. There is a limit on the amount of data returned as serialized JSON (~32Mb) and a total record limit of 100,000.
}
\details{
The SDA website can be found at \url{https://sdmdataaccess.nrcs.usda.gov}. See examples for bounding box formatting.
}
\note{
SDA does not return the spatial intersection of map unit polygons and bounding box. Rather, just those polygons that are completely within the bounding box / overlap with the bbox. This function requires the 'rgdal' package.
}
\author{
Dylan E. Beaudette
}
