% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncode.R
\name{get_NASIS_table_metadata}
\alias{get_NASIS_table_metadata}
\title{Get NASIS Table Metadata (Table and Column Descriptions)}
\usage{
get_NASIS_table_metadata(
  table = NULL,
  column = NULL,
  what.table = "TablePhysicalName",
  what.column = "ColumnPhysicalName",
  query_string = FALSE,
  dsn = NULL
)
}
\arguments{
\item{table}{Character vector of table identifiers to match. Default \code{NULL} for "all tables" (no constraint)}

\item{column}{Character vector of column identifiers to match. Default \code{NULL} for "all columns" (in selected tables, if any, otherwise no constraint)}

\item{what.table}{Column to match \code{table} against. Default: \code{TablePhysicalName}.}

\item{what.column}{Column to match \code{column} against. Default: \code{ColumnPhysicalName}.}

\item{query_string}{Default: \code{FALSE}; if \code{TRUE} return a character containing query that would be sent to NASIS.}

\item{dsn}{Optional: path or \emph{DBIConnection} to \link[=NASISLocalDatabase]{local database containing NASIS table structure}; default: \code{NULL}}
}
\value{
a \code{data.frame}
}
\description{
Retrieve a table containing table and column names with descriptions, help text, units of measure, etc. from NASIS 7 metadata tables.
}
\details{
These data are derived from the MetadataTable and MetadataTableColumn tables and describe the expected contents of standard NASIS tables and columns.

For NASIS choice lists based on domain and column names see \code{get_NASIS_metadata()} and \code{NASISChoiceList()}. This function (\code{get_NASIS_table_metadata()}) is intended for higher-level description of the expected contents of a NASIS database instance, rather than the codes/specific values used within columns.
}
\examples{
if (local_NASIS_defined())
 str(get_NASIS_table_metadata())
}
\seealso{
\code{get_NASIS_metadata()} \code{NASISChoiceList()} \code{uncode()} \code{code()}
}
