% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_plateau.R
\name{linear_plateau}
\alias{linear_plateau}
\alias{SS_LP}
\alias{boot_linear_plateau}
\title{Linear-plateau response function}
\usage{
SS_LP(x, a, b, xs)

linear_plateau(
  data = NULL,
  stv,
  ry,
  target = NULL,
  tidy = TRUE,
  plot = FALSE,
  resid = FALSE
)

boot_linear_plateau(data, stv, ry, n = 1000, target = NULL, ...)
}
\arguments{
\item{x}{selfstart arg. for explanatory variable in SSlinp Default: NULL}

\item{a}{selfstart arg. for intercept Default: NULL}

\item{b}{selfstart arg. for slope Default: NULL}

\item{xs}{selfstart arg. for break/join point in SSlinp Default: NULL}

\item{data}{Optional argument to call and object of type data.frame or data.table
containing the soil test value (STV) and relative yield (RY) data, Default: NULL}

\item{stv}{name of the vector containing soil test values (-) of type \code{numeric}.}

\item{ry}{name of the vector containing relative yield values (\%) of type \code{numeric}.}

\item{target}{\code{numeric} value of relative yield target (e.g. 90 for 90\%) to estimate the CSTV.
The target needs to be < plateau, otherwise, target = plateau.}

\item{tidy}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a tidy data frame or tibble (default), FALSE returns a list.}

\item{plot}{logical operator (TRUE/FALSE) to plot the linear-plateau model, Default: FALSE}

\item{resid}{logical operator (TRUE/FALSE) to plot residuals analysis, Default: FALSE}

\item{n}{sample size for the bootstrapping Default: 500}

\item{...}{when running bootstrapped samples, the \code{...} (open arguments) allows to add grouping variable/s (factor or character) Default: NULL}
}
\value{
returns an object of type \code{ggplot} if plot = TRUE.

returns a residuals plot if resid = TRUE.

returns an object of class \code{data.frame} if tidy = TRUE,

returns an object of class \code{list} if tidy = FALSE.

SS_LP: selfStart function to pass into the linear_plateau fit

linear_plateau: function

boot_linear_plateau: bootstrapping function
}
\description{
This function helps to fit a linear-plateau model in order to
estimate critical soil test values (CSTV) above which yield response becomes flat.
}
\details{
See \href{https://adriancorrendo.github.io/soiltestcorr/articles/linear_plateau_tutorial.html}{online-documentation} for additional details.
}
\note{
For extended reference, we recommend to visit:
https://gradcylinder.org/post/linear-plateau/ by Austin Pearce.
Self-start function code adapted from nlraa package by F. Miguez \url{https://github.com/femiguez/nlraa}
}
\examples{
\donttest{
 # Example dataset
 dat <- data.frame("ry" = c(65,80,85,88,90,94,93,96,97,95,98,100,99,99,100),
                   "stv" = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
 # Run
 fit_example_lp <- linear_plateau(data = dat, 
 ry = ry, stv = stv, resid = TRUE, plot = FALSE)
 fit_example_lp
}
}
\references{
Anderson, R. L., and Nelson, L. A. (1975).
A Family of Models Involving Intersecting Straight Lines and Concomitant Experimental Designs Useful in Evaluating Response to Fertilizer Nutrients.
\emph{Biometrics, 31(2), 303–318.} \doi{10.2307/2529422}
}
\seealso{
\code{\link[rlang]{eval_tidy}},\code{\link[rlang]{defusing-advanced}}
\code{\link[minpack.lm]{nlsLM}}
\code{\link[nlraa]{SSlinp}}
\code{\link[stats]{AIC}},\code{\link[stats]{lm}},\code{\link[stats]{optim}},\code{\link[stats]{coef}},\code{\link[stats]{predict}}
\code{\link[AICcmodavg]{AICc}}
\code{\link[modelr]{model-quality}}
\code{\link[nlstools]{nlsResiduals}}
\code{\link[dplyr]{bind}}
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{geom_rug}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{geom_abline}},\code{\link[ggplot2]{geom_path}},\code{\link[ggplot2]{annotate}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{theme}}
\code{\link[ggpp]{annotate}}
}
