lat <- 37.2
G0dm <- c(2.766, 3.491, 4.494, 5.912, 6.989, 7.742, 7.919, 7.027, 5.369, 3.562, 2.814, 2.179)*1000
Ta <- c(10, 14.1, 15.6, 17.2, 19.3, 21.2, 28.4, 29.9, 24.3, 18.2, 17.2, 15.2)
prom <- readG0dm(G0dm, Ta, lat = lat, year = 2023)
g0 <- calcG0(lat, dataRad = prom)
g0I <- as.data.tableI(g0)
g0D <- as.data.tableD(g0)
g0M <- as.data.tableM(g0)
g0Y <- as.data.tableY(g0)
g0I_expected <- read.csv('files/g0.csv', sep = ';')
g0D_expected <- read.csv('files/g0.D.csv', sep = ';')
g0M_expected <- read.csv('files/g0.M.csv', sep = ';')
g0Y_expected <- read.csv('files/g0.Y.csv', sep = ';')

test_that('irradiation and irradiance on the horizontal plane',{
    expect_equal(g0I$G0, g0I_expected$G0)
    expect_equal(g0I$D0, g0I_expected$D0)
    expect_equal(g0I$B0, g0I_expected$B0)
    expect_equal(g0D$G0d, g0D_expected$G0d)
    expect_equal(g0D$D0d, g0D_expected$D0d)
    expect_equal(g0D$B0d, g0D_expected$B0d)
    expect_equal(g0M$G0d, g0M_expected$G0d)
    expect_equal(g0M$D0d, g0M_expected$D0d)
    expect_equal(g0M$B0d, g0M_expected$B0d)
    expect_equal(g0Y$G0d, g0Y_expected$G0d)
    expect_equal(g0Y$D0d, g0Y_expected$D0d)
    expect_equal(g0Y$B0d, g0Y_expected$B0d)
})

set.seed('555')
g0 <- calcG0(lat, dataRad = list(G0dm = G0dm, year = 2024), modeRad = 'aguiar')
g0I <- as.data.tableI(g0)
g0D <- as.data.tableD(g0)
g0M <- as.data.tableM(g0)
g0Y <- as.data.tableY(g0)
g0I_expected <- read.csv('files/g0_aguiar.csv', sep = ';')
g0D_expected <- read.csv('files/g0_aguiar.D.csv', sep = ';')
g0M_expected <- read.csv('files/g0_aguiar.M.csv', sep = ';')
g0Y_expected <- read.csv('files/g0_aguiar.Y.csv', sep = ';')

test_that('calcG0 modeRad aguiar', {
    expect_equal(g0I$G0, g0I_expected$G0)
    expect_equal(g0I$D0, g0I_expected$D0)
    expect_equal(g0I$B0, g0I_expected$B0)
    expect_equal(g0D$G0d, g0D_expected$G0d)
    expect_equal(g0D$D0d, g0D_expected$D0d)
    expect_equal(g0D$B0d, g0D_expected$B0d)
    expect_equal(g0M$G0d, g0M_expected$G0d)
    expect_equal(g0M$D0d, g0M_expected$D0d)
    expect_equal(g0M$B0d, g0M_expected$B0d)
    expect_equal(g0Y$G0d, g0Y_expected$G0d)
    expect_equal(g0Y$D0d, g0Y_expected$D0d)
    expect_equal(g0Y$B0d, g0Y_expected$B0d)    
})

BDi <- g0I
BDi$Ta <- 25
g0 <- calcG0(lat, modeRad = 'bdI', dataRad = list(lat = 37.2, file = BDi), corr = 'none')
g0I <- as.data.tableI(g0)
g0D <- as.data.tableD(g0)
g0M <- as.data.tableM(g0)
g0Y <- as.data.tableY(g0)
g0I_expected <- read.csv('files/g0_bdI.csv', sep = ';')
g0D_expected <- read.csv('files/g0_bdI.D.csv', sep = ';')
g0M_expected <- read.csv('files/g0_bdI.M.csv', sep = ';')
g0Y_expected <- read.csv('files/g0_bdI.Y.csv', sep = ';')

test_that('calcG0 modeRad bdI', {
    expect_equal(g0I$G0, g0I_expected$G0)
    expect_equal(g0I$D0, g0I_expected$D0)
    expect_equal(g0I$B0, g0I_expected$B0)
    expect_equal(g0D$G0d, g0D_expected$G0d)
    expect_equal(g0D$D0d, g0D_expected$D0d)
    expect_equal(g0D$B0d, g0D_expected$B0d)
    expect_equal(g0M$G0d, g0M_expected$G0d)
    expect_equal(g0M$D0d, g0M_expected$D0d)
    expect_equal(g0M$B0d, g0M_expected$B0d)
    expect_equal(g0Y$G0d, g0Y_expected$G0d)
    expect_equal(g0Y$D0d, g0Y_expected$D0d)
    expect_equal(g0Y$B0d, g0Y_expected$B0d)        
})
