% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classSolarAssoc.R
\name{annotate}
\alias{annotate}
\title{Annotate SNPs in association study}
\usage{
annotate(x, mode = c("significant", "top", "all"), alpha = 0.05,
  num.top = 10, ...)
}
\arguments{
\item{x}{An object of class \code{solarAssoc} or a character vector of SNPs.}

\item{mode}{A character with the mode of SNPs selection.
Possible values are \code{"significant"}, \code{"top"} and \code{"all"}.
The default value is \code{"significant"}.}

\item{alpha}{A numeric value from 0 to 1, the significance level after Bonferroni multiple-test correction.
Corresponds to \code{mode} equal to \code{"significant"}.}

\item{num.top}{An integer value, the number of top SNPs to be annotated.
Corresponds to \code{mode} equal to \code{"top"}.
The default value is 10.}

\item{...}{Additional arguments passed to \code{annotateSNPs}.}
}
\value{
A data table with annotation results.
}
\description{
The function calls \code{\link{annotateSNPs}} function,
which does the job.
}
\seealso{
\code{\link{annotateSNPs}}
}

