% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transmittance.R
\name{Transmittance}
\alias{Transmittance}
\title{Atmospheric Transmittance}
\usage{
Transmittance(DOY, Lat, Lon, SLon, DS, Elevation)
}
\arguments{
\item{DOY}{Day of year}

\item{Lat}{Latitude (in degrees)}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}

\item{Elevation}{Elevation of the site in meters}
}
\description{
This function returns atmospheric transmittance coefficient for a given day of year and location.
}
\examples{

#Calculating atmospheric transmittance coefficient for two consecutive days on 45 degree
# latitude and 10 degree longitude and at 100 m altitude.

DOY <- seq(0, 2, .05)

tb <- Transmittance(DOY, Lat = 45, Lon=10, SLon=10, DS=0, Elevation = 100)

#Note: only the difference between Lon and SLon matters not each value

plot(DOY, tb)

}
\keyword{Atmospheric}
\keyword{Transmittance}
