% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.set.R
\name{som.nn.set}
\alias{som.nn.set}
\title{Set parameters for k-NN-like classifier in som.nn model}
\usage{
som.nn.set(model, x, dist.fun = NULL, max.dist = -1, name = "")
}
\arguments{
\item{model}{model of type \code{SOMnn}.}

\item{x}{data.fame with training data. Samples are requested as rows and taken randomly for the
training steps. All
columns except of the class lables are considered to be attributes and parts of
the training vector.
\code{x} must include the same columns as the data.frame with which the model
have been trained originally.
One column is needed as class labels. The column with class
lables is selected by the slot \code{class.idx} of the model.}

\item{dist.fun}{distance function for weighting distances between codebook
vectors on the som (kernel for k-NN classifier).}

\item{max.dist}{maximum distance to be considered by the nearest-neighbour counting.}

\item{name}{new name of the model.}
}
\value{
S4 object of type \code{\link{SOMnn}} with the updated model.
}
\description{
With the function parameters for the k-NN-like classification can be set for an existing self-organising 
map with hexagonal tolology.
}
\details{
The distance function defines the behaviour of the k-nearest-neighbour algorithm.
Choices for the distance function include \code{dist.fun.inverse} or \code{dist.fun.tricubic}, 
as defined in this package, or any other function that accepts exactly two arguments \code{x} 
(the distance) and \code{sigma} (a parameter defined by max.distance).

A data set for training must be presented to calculate the accuracy statistics of the
predictor.
}
\examples{
## get example data and add class labels:
data(iris)
species <- iris$Species

## train with default radius = diagonal / 2:
som <- som.nn.train(iris, class.col = "Species", 
                    xdim = 15, ydim = 9, alpha = 0.02, len = 10000, 
                    norm = TRUE, toroidal = FALSE)

## predict some samples:
unk <- iris[,!(names(iris) \%in\% "Species")]

setosa <- unk[species=="setosa",]
setosa <- setosa[sample(nrow(setosa), 20),]

versicolor <- unk[species=="versicolor",]
versicolor <- versicolor[sample(nrow(versicolor), 20),]

virginica <- unk[species=="virginica",]
virginica <- virginica[sample(nrow(virginica), 20),]

## predict with generic function:
predict(som, unk)

## predict with function in SOMnn object:
som@predict(setosa)
som@predict(versicolor)
som@predict(virginica)

## get mapping with visual:
som.nn.visual(som@codes, setosa)


## change parameters of k-NN classifier:
som.nn.set(som, iris, dist.fun = dist.fun.bubble, max.dist = 3.1)
som.nn.set(som, iris, dist.fun = dist.fun.tricubic, max.dist = 3)

## define custom distance function:
som <- som.nn.set(som, iris, dist.fun = function(x, sigma){
            ifelse(x < sigma, dnorm(x, sd = sigma), 0)}, 
            max.dist = 3)

predict(som, setosa)
som


}
\seealso{
\code{\link{dist.fun.bubble}}, \code{\link{dist.fun.linear}}, 
         \code{\link{dist.fun.inverse}}, \code{\link{dist.fun.tricubic}}.
}

