% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{resonantFrequency}
\alias{resonantFrequency}
\title{Calculate the resonant frequency}
\usage{
resonantFrequency(L, C = "default")
}
\arguments{
\item{L}{Inductance}

\item{C}{Capacitance, by default IUPAC standard pressure.}
}
\description{
Calculates the resonant frequency given the inductance and capacitance. In the acoustic case
the inductance is inertia or mass, the capacitance is elasticity (bulk modulus) and resistance is composed of air
resistance and related quantities. All units are SI.
}
\details{
For isothermal compression, the bulk modulus is equal to the pressure. The default value of C therefore is the IUPAC
standard pressure.
}
\examples{
f <- resonantFrequency(L=1)
}
