% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{evaluatePars}
\alias{evaluatePars}
\title{Evaluate parameters for optimization}
\usage{
evaluatePars(p, pars, myfun, bounds = NULL, fitnessPar,
  fitnessFun = function(x) 1 - cor(x, key, use =
  "pairwise.complete.obs"), myfolder, key, otherPars = list(plot = FALSE,
  verbose = FALSE), verbose = TRUE)
}
\arguments{
\item{p}{numeric vector of evaluated values of parameters}

\item{pars}{names of arguments to \code{myfun} that should be
optimized}

\item{myfun}{the function being optimized: either 'segmentFolder' or
'analyzeFolder' (in quotes)}

\item{bounds}{a list setting the lower and upper boundaries for possible
values of optimized parameters. For ex., if we optimize \code{smooth}
and \code{smoothOverlap}, reasonable bounds might be list(low = c(5,
0), high = c(500, 95))}

\item{fitnessPar}{the name of output variable that we are comparing with the
key, e.g. 'nBursts' or 'pitch_median'}

\item{fitnessFun}{the function used to evaluate how well the output of
\code{myfun} fits the key. Defaults to 1 - Pearson's correlation (i.e. 0 is
perfect fit, 1 is awful fit). For pitch, log scale is more meaningful, so a
good fitness criterion is "function(x) 1 - cor(log(x), log(key), use =
'pairwise.complete.obs')"}

\item{myfolder}{path to where the .wav files live}

\item{key}{a vector containing the "correct" measurement that we are aiming
to reproduce}

\item{otherPars}{a list of additional arguments to \code{myfun}}

\item{verbose}{if TRUE, reports the values of parameters evaluated and fitness}
}
\value{
Returns 1 - Pearson's correlation between fitness measure and the key
  (i.e. 0 is perfect fit, 1 is awful fit).
}
\description{
Internal soundgen function.
}
\details{
Called by \code{\link{optimizePars}}.
}
\keyword{internal}
