% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchTrackers.R
\name{getPitchAutocor}
\alias{getPitchAutocor}
\title{Autocorrelation pitch tracker}
\usage{
getPitchAutocor(
  autoCorrelation,
  samplingRate,
  nCands,
  autocorThres,
  autocorSmooth = NULL,
  autocorUpsample,
  autocorBestPeak,
  pitchFloor,
  pitchCeiling
)
}
\arguments{
\item{autoCorrelation}{pre-calculated autocorrelation of the input frame
(computationally more efficient than to do it here)}

\item{samplingRate}{sampling rate (Hz)}

\item{nCands}{maximum number of pitch candidates per method, normally 1...4
(except for \code{dom}, which returns at most one candidate per frame)}

\item{autocorThres}{voicing threshold (unitless, ~0 to 1)}

\item{autocorSmooth}{the width of smoothing interval (in bins) for
finding peaks in the autocorrelation function. Defaults to 7 for sampling
rate 44100 and smaller odd numbers for lower values of sampling rate}

\item{autocorUpsample}{upsamples acf to this resolution (Hz) to improve
accuracy in high frequencies}

\item{autocorBestPeak}{amplitude of the lowest best candidate relative to the
absolute max of the acf}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}
}
\value{
Returns a list of $HNR (NA or numeric) and $pitchAutocor_array
  (either NULL or a dataframe of pitch candidates).
}
\description{
Internal soundgen function.
}
\details{
Attempts to find F0 of a frame by looking for peaks in the autocorrelation
function (time domain analysis). Modified PRAAT's algorithm. See Boersma, P.
(1993). Accurate short-term analysis of the fundamental frequency and the
harmonics-to-noise ratio of a sampled sound. In Proceedings of the institute
of phonetic sciences (Vol. 17, No. 1193, pp. 97-110).
}
\keyword{internal}
