% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{htmlPlots}
\alias{htmlPlots}
\title{HTML for clickable plots}
\usage{
htmlPlots(
  x,
  savePlots,
  changesAudio,
  suffix,
  extension = "png",
  width = "900px"
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{savePlots}{a list of full names of files (with paths and extensions)}

\item{changesAudio}{if TRUE, it means we modify the input audio, so the
result shouldn't be saved in the original folder (if savePlots = '')}

\item{suffix}{an extra string to add before the extension, usually the name
of the function that calls htmlPlots, eg "spectrogram"}

\item{extension}{file extension for the saved plots}

\item{width}{the default width of flex elements in html}
}
\description{
Internal soundgen function
}
\details{
Writes an html file for displaying clickable plots in a browser.
}
\examples{
\dontrun{
## Functions that modify audio
# relative paths
flatEnv('/home/allgoodguys/Downloads/temp', savePlots = '')
flatEnv('/home/allgoodguys/Downloads/temp',
  savePlots = '/home/allgoodguys/Downloads/temp/compr',
  saveAudio = '/home/allgoodguys/Downloads/temp/compr')

# absolute paths
flatEnv('/home/allgoodguys/Downloads/temp', savePlots = '',
  saveAudio = '/home/allgoodguys/Downloads/temp/compr')
flatEnv('/home/allgoodguys/Downloads/temp',
  savePlots = '~/Downloads/temp/plots_compr')


## Functions that only analyze audio
getRMS('/home/allgoodguys/Downloads/temp', savePlots = '')
getRMS('/home/allgoodguys/Downloads/temp',
  savePlots = '~/Downloads/temp/plots_rms')
}
}
\keyword{internal}
