% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phasegram.R
\name{nonlinStats}
\alias{nonlinStats}
\title{Nonlinear statistics}
\usage{
nonlinStats(
  x,
  t = NULL,
  pars_ed = list(time.lag = t, max.embedding.dim = 15),
  pars_d2 = list(time.lag = t, min.embedding.dim = 2, min.radius = 0.001, max.radius =
    max(abs(x)) * 2, n.points.radius = 20, theiler.window = t * 2),
  pars_ml = list(time.lag = t, min.embedding.dim = 2, radius = 0.001, theiler.window = t
    * 2),
  pars_sur = list(FUN = nonlinearTseries::timeAsymmetry, K = 1),
  nonlinStats = c("ed", "d2", "ml", "sur")
)
}
\arguments{
\item{x}{numeric vector such as a sound or analysis frame}

\item{t}{time lag in points. Defaults to the number of steps beyond which the
mutual information function reaches its minimum - see
\code{\link[nonlinearTseries]{timeLag}}}

\item{pars_ed}{a list of control parameters passed to
\code{\link[nonlinearTseries]{estimateEmbeddingDim}}}

\item{pars_d2}{a list of control parameters passed to
\code{\link[nonlinearTseries]{corrDim}}}

\item{pars_ml}{a list of control parameters passed to
\code{\link[nonlinearTseries]{maxLyapunov}}}

\item{pars_sur}{a list of control parameters passed to
\code{\link[nonlinearTseries]{surrogateTest}}}
}
\description{
Estimates the optimal number of embedding dimensions (ed), correlation
dimension D2 (d2), maximum Lyapunov exponent (ml), and the results of
surrogate data testing for stochasticity (sur) using the functionality of the
package nonlinearTseries. This is basically just a wrapper that puts all
these functions together - convenient for frame-by-frame analysis, eg by
\code{\link{phasegram}}.
}
\examples{
x = sin((1:200) / 5) + rnorm(200, 0, .5)
plot(x, type = 'l')
soundgen:::nonlinStats(x)
}
\keyword{internal}
