% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinPred.R
\name{nonlinPred}
\alias{nonlinPred}
\title{Nonlinear prediction}
\usage{
nonlinPred(
  x,
  nPoints = 1,
  time.lag = NULL,
  embedding.dim = NULL,
  max.embedding.dim = 15,
  threshold = 0.95,
  max.relative.change = 0.1,
  radius = NULL,
  radius.increment = NULL,
  plot = FALSE
)
}
\arguments{
\item{x}{numeric vector}

\item{nPoints}{number of points to predict, ideally not more than length(x) /
2 (the function is called recursively to predict longer sequences, but
don't expect miracles)}

\item{time.lag}{time lag for constructing Takens vectors. Defaults to the
time to the first exponential decay of mutual information. See
\code{\link[nonlinearTseries]{timeLag}}}

\item{embedding.dim}{the number of dimensions of the phase space. Defaults to
an estimate based on
\code{\link[nonlinearTseries]{estimateEmbeddingDim}}}

\item{max.embedding.dim, threshold, max.relative.change}{parameters used to
estimate the optimal number of embedding dimensions - see
\code{\link[nonlinearTseries]{estimateEmbeddingDim}}}

\item{radius, radius.increment}{the radius used for detecting neighbors in the
phase space and its increment in case no neighbors are found - see
\code{\link[nonlinearTseries]{nonLinearPrediction}}}

\item{plot}{if TRUE, plots the original time series and the predictions}
}
\value{
Returns a numeric vector on the same scale as input \code{x}.
}
\description{
Predicts new points in a time series. The functionality is provided by
\code{\link[nonlinearTseries]{nonLinearPrediction}}. This function is just a
simple wrapper "for dummies" that reconstructs the phase space under the
hood, including the choice of time lag, embedding dimensions, etc. It can
also predict not one but many points in a single step.
}
\examples{
x = c(rep(1, 3), rep(0, 4), rep(1, 3), rep(0, 4), rep(1, 3), 0, 0)
nonlinPred(x, 5, plot = TRUE)

nonlinPred(sin(1:25), 22, plot = TRUE)

x = soundgen(sylLen = 50, addSilence = 0)[250:450]
nonlinPred(x, 100, plot = TRUE)

nonlinPred(c(rnorm(5), NA, rnorm(3)))
nonlinPred(1:4)
nonlinPred(1:6)

\dontrun{
s1 = soundgen(sylLen = 500, pitch = rnorm(5, 200, 20),
              addSilence = 0, plot = TRUE)
playme(s1)
length(s1)
# we can predict output that is longer than the original time series by
# predicting a bit at a time and using the output as the new input
s2 = nonlinPred(s1, 16000)
spectrogram(c(s1, s2))
playme(c(s1, s2))
}
}
