\name{prior}
\alias{prior}

\title{Creates prior distribution definitions}

\description{
  The function \code{prior} creates a valid prior definition for use in \code{\link{spGGT}}.
}

\usage{
prior(dist, ...)
}

\arguments{
  \item{dist}{a quoted key word that identifies the prior distribution.  The
    choices are inverse-gamma \code{"IG"}, uniform \code{"UNIF"}, half-Cauchy \code{"HC"}, normal
    \code{"NORMAL"}, flat \code{"FLAT"}, inverse-Wishart \code{"IWISH"},
    and fixed scalar or matrix \code{"FIXED"}.  }
  \item{...}{the hyperparameters of the chosen prior distribution,
    passed as quoted key words with associated values. See details below.  }
}

\value{
  \item{prior}{a list object of class \code{ggt.prior} which is used for the value portion of the \code{prior} tag in
  the \code{\link{spGGT}} function. }
}


\details{
  Up to a proportionality constant the possible priors are:
  \itemize{
    \item{Uniform: }{\eqn{1/(b-a), b > a}{1/(b-a)}, where \eqn{b >
	a}. Use key words \code{"a"}, and \code{"b"}. }
    
    \item{Inverse-gamma: }{\eqn{x^{-(a+1)} exp(-b/x)}{x^{-(a+1)}
	exp(-b/x)}, where \eqn{a} is shape \eqn{> 0} and \eqn{b} is scale \eqn{> 0}.
      Use key words \code{"shape"}, and \code{"scale"}. }
    
    \item{Half-Cauchy:}{\eqn{(x + a^2)^{-1}}{(x + a^2)^{-1}}. Use key word \code{"a"}. }
    
    \item{Normal:}{\eqn{exp(-1/2 (\beta - mu)^t V^{-1} (\beta -
	mu))}{exp(-1/2 (B - mu)^t V^{-1} (B - mu))}, where \eqn{mu} is the
      mean vector of length \eqn{p} and \eqn{V^{-1}}{V^{-1}} is the
      \eqn{p \times p}{p x p} precision matrix.  Use key words
      \code{"mu"} and \code{"precision"}. }

    \item{Inverse-Wishart: }{\eqn{det(S)^{df/2}det(W)^{-(df+m+1)/2}exp(-1/2
	tr(SW^{-1}))}{det(S)^{df/2}det(W)^{-(df+m+1)/2}exp(-1/2
	tr(SW^{-1}))}, where \eqn{W} is the \eqn{m \times m}{m x m} covariance
      matrix, \eqn{df} is the degrees of freedom, and \eqn{S} is the
      positive definite \eqn{m \times m}{m x m} scale matrix. Use key words
      \code{"df"} and \code{"S"}. }
  }
  The normal and flat priors can only be used for the regressors specified in \code{\link{spGGT}}.
}


\references{
  Banerjee, S., Carlin, B.P., and Gelfand, A.E. (2004). Hierarchical modeling and analysis for spatial data. Chapman and Hall/CRC Press, Boca Raton, Fla.

  Gelman, A. (2006). Prior distributions for variance parameters in
  hierarchical models 1(3):515-533, Bayesian Analysis.
  
}

\author{
  Andrew O. Finley \email{finleya@msu.edu}, \cr
  Sudipto Banerjee \email{sudiptob@biostat.umn.edu}.
}

\seealso{\code{\link{spGGT}} }

\keyword{misc}
