% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection_cv_sf.R
\name{nkde_worker_bw_sel}
\alias{nkde_worker_bw_sel}
\title{Bandwidth selection by likelihood cross validation worker function}
\usage{
nkde_worker_bw_sel(
  lines,
  quad_events,
  events_loc,
  events,
  w,
  kernel_name,
  bws_net,
  method,
  div,
  digits,
  tol,
  sparse,
  max_depth,
  zero_strat = "min_double",
  verbose = FALSE,
  cvl = FALSE
)
}
\arguments{
\item{lines}{A feature collection of linestrings representing the underlying network}

\item{quad_events}{a feature collection of points indicating for which events the densities must be calculated}

\item{events_loc}{A feature collection of points representing the location of the events}

\item{events}{A feature collection of points representing the events. Multiple events can share
the same location. They are linked by the goid column}

\item{w}{A numeric matrix with the weight of the events for each bandwdith}

\item{kernel_name}{The name of the kernel to use (string)}

\item{bws_net}{A numeric vector with the network bandwidths}

\item{method}{The type of NKDE to use (string)}

\item{digits}{The number of digits to retain from the spatial coordinates. It
ensures that topology is good when building the network. Default is 3. Too high a
precision (high number of digits) might break some connections}

\item{tol}{A float indicating the minimum distance between the events and the
lines' extremities when adding the point to the network. When points are
closer, they are added at the extremity of the lines.}

\item{sparse}{A Boolean indicating if sparse or regular matrices should be
used by the Rcpp functions. These matrices are used to store edge indices
between two nodes in a graph. Regular matrices are faster, but require more
memory, in particular with multiprocessing. Sparse matrices are slower (a
bit), but require much less memory.}

\item{zero_strat}{A string indicating what to do when density is 0 when calculating LOO density estimate for an isolated event.
"min_double" (default) replace the 0 value by the minimum double possible on the machine. "remove" will remove them from the final
score. The first approach penalizes more strongly the small bandwidths.}

\item{verbose}{A boolean}

\item{cvl}{A boolean indicating if the cvl method (TRUE) or the loo (FALSE) method must be used}

\item{agg}{A double indicating if the events must be aggregated within a
distance. If NULL, the events are aggregated only by rounding the
coordinates.}
}
\description{
worker function for calculating for multiple bandwidth the cross validation likelihood to
select an appropriate bandwidth in a data-driven approach
}
\examples{
# no example provided, this is an internal function
}
\keyword{internal}
