% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-extractor-functions.R
\name{get-functions}
\alias{get-functions}
\alias{get_tokens}
\alias{get_tags}
\alias{get_attrs}
\alias{get_named_entities}
\alias{get_dependency}
\alias{get_ntokens}
\alias{get_ntokens_by_sent}
\title{get functions for spaCy}
\usage{
get_tokens(spacy_out)

get_tags(spacy_out, tagset = c("google", "detailed"))

get_attrs(spacy_out, attr_name, deal_utf8 = FALSE)

get_named_entities(spacy_out)

get_dependency(spacy_out)

get_ntokens(spacy_out)

get_ntokens_by_sent(spacy_out)
}
\arguments{
\item{spacy_out}{a spacy_out object}

\item{tagset}{character label for the tagset to use, either \code{"google"} 
or \code{"detailed"} to use the simplified Google tagset, or the more detailed 
scheme from the Penn Treebank (or the German Text Archive in case of German language model).}

\item{attr_name}{name of spaCy token attributes to extract}
}
\value{
\code{get_tokens} returns a data.frame of tokens from spaCy.

\code{get_tags} returns a tokenized text object with part-of-speech tags.
Options exist for using either the Google or Detaled tagsets. See 
\url{http://spacy.io}.

\code{get_attrs} returns a list of attributes from spaCy output

\code{get_named_entities} returns a list of named entities in texts

\code{get_dependency} returns a data.frame of dependency relations.

\code{get_ntokens} returns a data.frame of dependency relations

\code{get_ntokens_by_sent} returns a data.frame of dependency
  relations, by sentence
}
\description{
A collection of get methods for spacyr return objects (of \code{spacy_out} class).
}
\examples{
\donttest{
# get_tags examples
txt <- c(text1 = "This is the first sentence.\\nHere is the second sentence.", 
         text2 = "This is the second document.")
results <- spacy_parse(txt)
tokens <- tokens(results)
tokens_with_tag <- tokens_tag(tokens)

}
}
\keyword{internal}
