% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available-data.R
\name{spod_available_data_v2}
\alias{spod_available_data_v2}
\title{Get the data dictionary}
\usage{
spod_available_data_v2(
  data_dir = spod_get_data_dir(),
  check_local_files = FALSE,
  use_s3 = TRUE,
  force = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{data_dir}{The directory where the data is stored. Defaults to the value returned by \code{spod_get_data_dir()}.}

\item{check_local_files}{Logical. Whether to check if the local files exist and get the file size. Defaults to \code{FALSE}.}

\item{use_s3}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical. If \code{TRUE}, use Amazon S3 to get available data list, which does not require downloading the XML file and caching it locally, which may be a bit faster. If \code{FALSE}, use the XML file to get available data list.}

\item{force}{Logical. If \code{TRUE}, force re-download of metadata. For Amazon S3 this queries the S3 bucket for the XML file it re-downloads. If \code{FALSE}, only update the available data list if it is older than 1 day.}

\item{quiet}{A \code{logical} value indicating whether to suppress messages. Default is \code{FALSE}.}
}
\value{
A tibble with links, release dates of files in the data, dates of data coverage, local paths to files, and the download status.
\describe{
\item{target_url}{\code{character}. The URL link to the data file.}
\item{pub_ts}{\code{POSIXct}. The timestamp of when the file was published.}
\item{file_extension}{\code{character}. The file extension of the data file (e.g., 'tar', 'gz').}
\item{data_ym}{\code{Date}. The year and month of the data coverage, if available.}
\item{data_ymd}{\code{Date}. The specific date of the data coverage, if available.}
\item{study}{\code{factor}. Study category derived from the URL (e.g., 'basic', 'complete', 'routes').}
\item{type}{\code{factor}. Data type category derived from the URL (e.g., 'number_of_trips', 'origin-destination', 'overnight_stays', 'data_quality', 'metadata').}
\item{period}{\code{factor}. Temporal granularity category derived from the URL (e.g., 'day', 'month').}
\item{zones}{\code{factor}. Geographic zone classification derived from the URL (e.g., 'districts', 'municipalities', 'large_urban_areas').}
\item{local_path}{\code{character}. The local file path where the data is (or going to be) stored.}
\item{downloaded}{\code{logical}. Indicator of whether the data file has been downloaded locally. This is only available if \code{check_local_files} is \code{TRUE}.}
}
}
\description{
This function retrieves the data dictionary for the specified data directory.
}
\keyword{internal}
