% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mol_parameters.R
\name{get_uncoupled_mol}
\alias{get_uncoupled_mol}
\title{Generate a \code{mol_parameters} object for a simple spin system with one
resonance.}
\usage{
get_uncoupled_mol(
  name,
  chem_shift,
  nucleus,
  scale_factor,
  lw,
  lg,
  full_name = NULL
)
}
\arguments{
\item{name}{abbreviated name of the molecule.}

\item{chem_shift}{chemical shift of the resonance (PPM).}

\item{nucleus}{nucleus (1H, 31P...).}

\item{scale_factor}{multiplicative scaling factor. Note, this value can be
made complex to adjust the phase of the resonance.}

\item{lw}{linewidth in Hz.}

\item{lg}{Lorentz-Gauss lineshape parameter (between 0 and 1).}

\item{full_name}{long name of the molecule (optional).}
}
\value{
mol_parameters object.
}
\description{
Generate a \code{mol_parameters} object for a simple spin system with one
resonance.
}
