% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_fpm_fpgrowth.R
\name{ml_fpgrowth}
\alias{ml_fpgrowth}
\alias{ml_association_rules}
\alias{ml_freq_itemsets}
\title{Frequent Pattern Mining -- FPGrowth}
\usage{
ml_fpgrowth(x, items_col = "items", min_confidence = 0.8,
  min_support = 0.3, prediction_col = "prediction",
  uid = random_string("fpgrowth_"), ...)

ml_association_rules(model)

ml_freq_itemsets(model)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{items_col}{Items column name. Default: "items"}

\item{min_confidence}{Minimal confidence for generating Association Rule.
\code{min_confidence} will not affect the mining for frequent itemsets, but
will affect the association rules generation. Default: 0.8}

\item{min_support}{Minimal support level of the frequent pattern. [0.0, 1.0].
Any pattern that appears more than (min_support * size-of-the-dataset) times
 will be output in the frequent itemsets. Default: 0.3}

\item{prediction_col}{Prediction column name.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; currently unused.}

\item{model}{A fitted FPGrowth model returned by \code{ml_fpgrowth()}}
}
\description{
A parallel FP-growth algorithm to mine frequent itemsets.
}
