% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_regression_isotonic_regression.R
\name{ml_isotonic_regression}
\alias{ml_isotonic_regression}
\title{Spark ML -- Isotonic Regression}
\usage{
ml_isotonic_regression(x, formula = NULL, feature_index = 0,
  isotonic = TRUE, weight_col = NULL, features_col = "features",
  label_col = "label", prediction_col = "prediction",
  uid = random_string("isotonic_regression_"), ...)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{formula}{Used when \code{x} is a \code{tbl_spark}. R formula as a character string or a formula. This is used to transform the input dataframe before fitting, see \link{ft_r_formula} for details.}

\item{feature_index}{Index of the feature if \code{features_col} is a vector column (default: 0), no effect otherwise.}

\item{isotonic}{Whether the output sequence should be isotonic/increasing (true) or antitonic/decreasing (false). Default: true}

\item{weight_col}{The name of the column to use as weights for the model fit.}

\item{features_col}{Features column name, as a length-one character vector. The column should be single vector column of numeric values. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{label_col}{Label column name. The column should be a numeric column. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{prediction_col}{Prediction column name.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; see Details.}
}
\value{
The object returned depends on the class of \code{x}.

\itemize{
  \item \code{spark_connection}: When \code{x} is a \code{spark_connection}, the function returns an instance of a \code{ml_predictor} object. The object contains a pointer to
  a Spark \code{Predictor} object and can be used to compose
  \code{Pipeline} objects.

  \item \code{ml_pipeline}: When \code{x} is a \code{ml_pipeline}, the function returns a \code{ml_pipeline} with
  the predictor appended to the pipeline.

  \item \code{tbl_spark}: When \code{x} is a \code{tbl_spark}, a predictor is constructed then
  immediately fit with the input \code{tbl_spark}, returning a prediction model.

  \item \code{tbl_spark}, with \code{formula}: specified When \code{formula}
    is specified, the input \code{tbl_spark} is first transformed using a
    \code{RFormula} transformer before being fit by
    the predictor. The object returned in this case is a \code{ml_model} which is a
    wrapper of a \code{ml_pipeline_model}.
}
}
\description{
Currently implemented using parallelized pool adjacent violators algorithm. Only univariate (single feature) algorithm supported.
}
\details{
When \code{x} is a \code{tbl_spark} and \code{formula} (alternatively, \code{response} and \code{features}) is specified, the function returns a \code{ml_model} object wrapping a \code{ml_pipeline_model} which contains data pre-processing transformers, the ML predictor, and, for classification models, a post-processing transformer that converts predictions into class labels. For classification, an optional argument \code{predicted_label_col} (defaults to \code{"predicted_label"}) can be used to specify the name of the predicted label column. In addition to the fitted \code{ml_pipeline_model}, \code{ml_model} objects also contain a \code{ml_pipeline} object where the ML predictor stage is an estimator ready to be fit against data. This is utilized by \code{\link{ml_save}} with \code{type = "pipeline"} to faciliate model refresh workflows.
}
\examples{
\dontrun{
sc <- spark_connect(master = "local")
iris_tbl <- sdf_copy_to(sc, iris, name = "iris_tbl", overwrite = TRUE)

partitions <- iris_tbl \%>\%
  sdf_partition(training = 0.7, test = 0.3, seed = 1111)

iris_training <- partitions$training
iris_test <- partitions$test

iso_res <- iris_tbl \%>\%
  ml_isotonic_regression(Petal_Length ~ Petal_Width)

pred <- sdf_predict(iris_test, iso_res)

pred
}

}
\seealso{
See \url{http://spark.apache.org/docs/latest/ml-classification-regression.html} for
  more information on the set of supervised learning algorithms.

Other ml algorithms: \code{\link{ml_aft_survival_regression}},
  \code{\link{ml_decision_tree_classifier}},
  \code{\link{ml_gbt_classifier}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_linear_svc}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron_classifier}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}},
  \code{\link{ml_random_forest_classifier}}
}
\concept{ml algorithms}
