/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import sparklyr.DaysSinceEpoch;
import sparklyr.Logical;
import sparklyr.Numeric;

public final class Serializer$ {
    public static final Serializer$ MODULE$;
    private final long kMsPerDay;

    static {
        new Serializer$();
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(DataInputStream in) {
        void var3_3;
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        return var3_3;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        if (bytes[len - 1] != 0) {
            throw new IllegalArgumentException("length and stream do not match");
        }
        String str = new String((byte[])Predef$.MODULE$.byteArrayOps(bytes).dropRight(1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        int intVal = in.readInt();
        return intVal != 0;
    }

    public Date readDate(DataInputStream in) {
        int n = this.readInt(in);
        return n == Integer.MIN_VALUE ? null : new Date(Predef$.MODULE$.Long2long(Long.valueOf(n)) * this.kMsPerDay);
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        long sec = (long)Math.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$1;

            public final byte[] apply(int x$1) {
                return Serializer$.MODULE$.readBytes(this.in$1);
            }
            {
                this.in$1 = in$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            public final DataInputStream in$2;

            public final int apply(int x$2) {
                return Serializer$.MODULE$.readInt(this.in$2);
            }

            public int apply$mcII$sp(int x$2) {
                return Serializer$.MODULE$.readInt(this.in$2);
            }
            {
                this.in$2 = in$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            public final DataInputStream in$3;

            public final double apply(int x$3) {
                return Serializer$.MODULE$.readDouble(this.in$3);
            }

            public double apply$mcDI$sp(int x$3) {
                return Serializer$.MODULE$.readDouble(this.in$3);
            }
            {
                this.in$3 = in$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            public final DataInputStream in$4;

            public final boolean apply(int x$4) {
                return Serializer$.MODULE$.readBoolean(this.in$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return Serializer$.MODULE$.readBoolean(this.in$4);
            }
            {
                this.in$4 = in$4;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$5;

            public final String apply(int x$5) {
                return Serializer$.MODULE$.readString(this.in$5);
            }
            {
                this.in$5 = in$5;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Date[] readDateArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (Date[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$6;

            public final Date apply(int x$6) {
                return Serializer$.MODULE$.readDate(this.in$6);
            }
            {
                this.in$6 = in$6;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    public Timestamp[] readTimeArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (Timestamp[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$7;

            public final Timestamp apply(int x$7) {
                return Serializer$.MODULE$.readTime(this.in$7);
            }
            {
                this.in$7 = in$7;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        block17: {
            block3: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block5: {
                                                                block4: {
                                                                    block2: {
                                                                        if ("void" != null ? !"void".equals(typeStr) : typeStr != null) break block2;
                                                                        dos.writeByte(110);
                                                                        break block3;
                                                                    }
                                                                    if ("character" != null ? !"character".equals(typeStr) : typeStr != null) break block4;
                                                                    dos.writeByte(99);
                                                                    break block3;
                                                                }
                                                                if ("double" != null ? !"double".equals(typeStr) : typeStr != null) break block5;
                                                                dos.writeByte(100);
                                                                break block3;
                                                            }
                                                            if ("integer" != null ? !"integer".equals(typeStr) : typeStr != null) break block6;
                                                            dos.writeByte(105);
                                                            break block3;
                                                        }
                                                        if ("logical" != null ? !"logical".equals(typeStr) : typeStr != null) break block7;
                                                        dos.writeByte(98);
                                                        break block3;
                                                    }
                                                    if ("date" != null ? !"date".equals(typeStr) : typeStr != null) break block8;
                                                    dos.writeByte(68);
                                                    break block3;
                                                }
                                                if ("time" != null ? !"time".equals(typeStr) : typeStr != null) break block9;
                                                dos.writeByte(116);
                                                break block3;
                                            }
                                            if ("raw" != null ? !"raw".equals(typeStr) : typeStr != null) break block10;
                                            dos.writeByte(114);
                                            break block3;
                                        }
                                        if ("array" != null ? !"array".equals(typeStr) : typeStr != null) break block11;
                                        dos.writeByte(97);
                                        break block3;
                                    }
                                    if ("strarray" != null ? !"strarray".equals(typeStr) : typeStr != null) break block12;
                                    dos.writeByte(102);
                                    break block3;
                                }
                                if ("list" != null ? !"list".equals(typeStr) : typeStr != null) break block13;
                                dos.writeByte(108);
                                break block3;
                            }
                            if ("map" != null ? !"map".equals(typeStr) : typeStr != null) break block14;
                            dos.writeByte(101);
                            break block3;
                        }
                        if ("jobj" != null ? !"jobj".equals(typeStr) : typeStr != null) break block15;
                        dos.writeByte(106);
                        break block3;
                    }
                    if ("json" != null ? !"json".equals(typeStr) : typeStr != null) break block16;
                    dos.writeByte(74);
                    break block3;
                }
                if ("sparkapplybinaryresult" != null ? !"sparkapplybinaryresult".equals(typeStr) : typeStr != null) break block17;
                dos.writeByte(36);
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeStr})));
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeNumeric(DataOutputStream out, Numeric x) {
        if (x.value().isEmpty()) {
            out.writeInt(0x7FF00000);
            out.writeInt(1954);
        } else {
            this.writeDouble(out, BoxesRunTime.unboxToDouble((Object)x.value().get()));
        }
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        Predef$ predef$ = Predef$.MODULE$;
        out.writeInt(new RichBoolean(value).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public void writeLogical(DataOutputStream out, Logical value) {
        out.writeInt(value.intValue());
    }

    public void writeDate(DataOutputStream out, Date value) {
        this.writeInt(out, value == null ? Integer.MIN_VALUE : (int)(value.getTime() / this.kMsPerDay));
    }

    public void writeDate(DataOutputStream out, DaysSinceEpoch d) {
        Option<Object> option = d.value();
        int n = BoxesRunTime.unboxToInt((Object)(!option.isEmpty() ? option.get() : BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)));
        out.writeInt(n);
    }

    public double timestampToSeconds(java.util.Date value) {
        double d;
        if (value == null) {
            d = Double.NaN;
        } else {
            double d2;
            double seconds = (double)value.getTime() / 1000.0;
            if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                d2 = seconds + (double)timestamp.getNanos() / 1.0E9;
            } else {
                d2 = seconds;
            }
            d = d2;
        }
        return d;
    }

    public void writeTime(DataOutputStream out, java.util.Date value) {
        out.writeDouble(this.timestampToSeconds(value));
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        if (value == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(value.length);
            out.write(value);
        }
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        Predef$.MODULE$.intArrayOps(value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            public final DataOutputStream out$1;

            public final void apply(int v) {
                this.out$1.writeInt(v);
            }

            public void apply$mcVI$sp(int v) {
                this.out$1.writeInt(v);
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        Predef$.MODULE$.doubleArrayOps(value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            public final DataOutputStream out$2;

            public final void apply(double v) {
                this.out$2.writeDouble(v);
            }

            public void apply$mcVD$sp(double v) {
                this.out$2.writeDouble(v);
            }
            {
                this.out$2 = out$2;
            }
        });
    }

    public void writeNumericArr(DataOutputStream out, Numeric[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$3;

            public final void apply(Numeric v) {
                Serializer$.MODULE$.writeNumeric(this.out$3, v);
            }
            {
                this.out$3 = out$3;
            }
        });
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        Predef$.MODULE$.booleanArrayOps(value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$4;

            public final void apply(boolean v) {
                Serializer$.MODULE$.writeBoolean(this.out$4, v);
            }
            {
                this.out$4 = out$4;
            }
        });
    }

    public void writeLogicalArr(DataOutputStream out, Logical[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$5;

            public final void apply(Logical v) {
                Serializer$.MODULE$.writeInt(this.out$5, v.intValue());
            }
            {
                this.out$5 = out$5;
            }
        });
    }

    public void writeTimestampArr(DataOutputStream out, Timestamp[] value) {
        this.writeType(out, "time");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$6;

            public final void apply(Timestamp v) {
                Serializer$.MODULE$.writeTime(this.out$6, v);
            }
            {
                this.out$6 = out$6;
            }
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value) {
        String all = Predef$.MODULE$.refArrayOps((Object[])value).mkString("\u0019");
        this.writeString(out, all);
    }

    public void writeDateArr(DataOutputStream out, Date[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$7;

            public final void apply(Date v) {
                Serializer$.MODULE$.writeDate(this.out$7, v);
            }
            {
                this.out$7 = out$7;
            }
        });
    }

    public void writeDateArr(DataOutputStream out, DaysSinceEpoch[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$8;

            public final void apply(DaysSinceEpoch v) {
                Serializer$.MODULE$.writeDate(this.out$8, v);
            }
            {
                this.out$8 = out$8;
            }
        });
    }

    private Serializer$() {
        MODULE$ = this;
        this.kMsPerDay = 86400000L;
    }
}

