% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_extensions.R
\name{spark_dependency}
\alias{spark_dependency}
\title{Define a Spark dependency}
\usage{
spark_dependency(
  jars = NULL,
  packages = NULL,
  initializer = NULL,
  catalog = NULL,
  repositories = NULL,
  dbplyr_sql_variant = NULL,
  ...
)
}
\arguments{
\item{jars}{Character vector of full paths to JAR files.}

\item{packages}{Character vector of Spark packages names.}

\item{initializer}{Optional callback function called when initializing a connection.}

\item{catalog}{Optional location where extension JAR files can be downloaded for Livy.}

\item{repositories}{Character vector of Spark package repositories.}

\item{dbplyr_sql_variant}{Customization of dbplyr SQL translation env. Must be a
named list of the following form:
  list(
    scalar = list(scalar_fn1 = ..., scalar_fn2 = ..., <etc>),
    aggregate = list(agg_fn1 = ..., agg_fn2 = ..., <etc>),
    window = list(wnd_fn1 = ..., wnd_fn2 = ..., <etc>)
  )
See \link[dbplyr:sql_substr]{sql_variant} for details.}

\item{...}{Additional optional arguments.}
}
\value{
An object of type `spark_dependency`
}
\description{
Define a Spark dependency consisting of a set of custom JARs, Spark packages,
and customized dbplyr SQL translation env.
}
