#' Data sets
#'
#' Detrano data sets (cleveland, hungarian, switzerland, va);
#' The Iowa Radon Lung Cancer Study (irlcs_radon_syn): Data simulated to resemble the IRLCS study;
#' Sheddon survival data (Z: clinical covariates, S:survival outcome)
#'
#' @name datasets
#'
#' @aliases Z S va hungarian cleveland irlcs_radon_syn
#'
#' @source
#' \describe{
#'   \item{Detrano data}{\url{https://archive.ics.uci.edu/ml/datasets/heart+disease}}
#'   \item{IRLCS data sets}{\url{https://cheec.uiowa.edu/research/residential-radon-and-lung-cancer-case-control-study}}
#'   \item{Sheddon}{\url{https://www.gsea-msigdb.org/gsea/msigdb/cards/SHEDDEN_LUNG_CANCER_POOR_SURVIVAL_A6}}
#' }
#' @references
#' \describe{
#'   \item{Detrano}{
#'   Detrano, R., Janosi, A., Steinbrunn, W., Pfisterer, M., Schmid, J., Sandhu, S., Guppy, K.,
#'   Lee, S., & Froelicher, V. (1989). International application of a new probability algorithm
#'   for the diagnosis of coronary artery disease. American Journal of Cardiology, 64,304--310.
#'   }
#'   \item{IRLCS}{
#'     FIELD, R., SMITH, B., STECK, D. et al. Residential radon exposure and lung cancer:
#'     Variation in risk estimates using alternative exposure scenarios. J Expo Sci Environ Epidemiol
#'     12, 197–203 (2002). \url{https://www.nature.com/articles/7500215}
#'   }
#'   \item{Shedden}{
#'   Director's Challenge Consortium for the Molecular Classification of Lung Adenocarcinoma, Shedden, K.,
#'   Taylor, J. M., Enkemann, S. A., Tsao, M. S., Yeatman, T. J., Gerald, W. L., Eschrich, S., Jurisica, I.,
#'   Giordano, T. J., Misek, D. E., Chang, A. C., Zhu, C. Q., Strumpf, D., Hanash, S., Shepherd, F. A., Ding,
#'   K., Seymour, L., Naoki, K., Pennell, N., … Beer, D. G. (2008). Gene expression-based survival prediction
#'   in lung adenocarcinoma: a multi-site, blinded validation study. Nature medicine, 14(8), 822–827.
#'   \url{https://www.nature.com/articles/nm.1790}
#'   }
#' }
#'
"cleveland"

#' @rdname datasets
"hungarian"

#' @rdname datasets
"switzerland"

#' @rdname datasets
"va"

#' @rdname datasets
"irlcs_radon_syn"

#' @rdname datasets
"Z"

#' @rdname datasets
"S"
