% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_utilities.R
\name{use_ensemble_to_generate_predictions}
\alias{use_ensemble_to_generate_predictions}
\title{Predict simulation responses for a parameter set using an ensemble}
\usage{
use_ensemble_to_generate_predictions(generated_ensemble, data_to_predict,
  parameters, measures, normalise_values = FALSE, normalise_result = FALSE)
}
\arguments{
\item{generated_ensemble}{Ensemble to use to make predictions}

\item{data_to_predict}{Parameter sets to make predictions from}

\item{parameters}{Simulation parameter names}

\item{measures}{Simulation output response names}

\item{normalise_values}{Whether the unseen parameter sets should be
normalised to be between 0 and 1}

\item{normalise_result}{Whether the generated predictions should be
normalised to be between 0 and 1}
}
\value{
List of predictions made for specified responses for all
parameter sets
}
\description{
This takes a set of unseen parameter values and uses an ensemble to make
predictions of the responses that the simulator would generate
}
