% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spartan_utilities.R
\name{partition_dataset}
\alias{partition_dataset}
\title{Partition latin-hypercube summary file to training, testing, and validation}
\usage{
partition_dataset(dataset, parameters, measures, percent_train = 75,
  percent_test = 15, percent_validation = 10, seed = NULL,
  normalise = FALSE, sample_mins = NULL, sample_maxes = NULL,
  timepoint = NULL)
}
\arguments{
\item{dataset}{LHC summary file to partition}

\item{parameters}{Simulation parameters the emulation will be fed as input}

\item{measures}{Simulation responses of interest}

\item{percent_train}{Percent of the dataset to use as training}

\item{percent_test}{Percent of the dataset to use as testing}

\item{percent_validation}{Percent of the dataset to use as validation}

\item{seed}{For specifying a particular seed when randomly splitting the set}

\item{normalise}{Whether the data needs to be normalised (to be between 0
and 1). For emulation creation to be successful, all data must be normalised
prior to use in training and testing}

\item{sample_mins}{The minimum value used for each parameter in generating
the latin-hypercube sample}

\item{sample_maxes}{The maximum value used for each parameter in generating
the latin-hypercube sample}

\item{timepoint}{Simulation timepoint for which this summary file was created}
}
\value{
Partitioned dataset containing training, testing, and validation
sets, in addition to the sample mins and maxes such that any predictions
that are generated using this normalised data can be rescaled correctly
}
\description{
Used in the development of emulations of a simulation using a
latin-hypercube summary file
}
\examples{
data("sim_data_for_emulation")
parameters<-c("stableBindProbability","chemokineExpressionThreshold",
"initialChemokineExpressionValue","maxChemokineExpressionValue",
"maxProbabilityOfAdhesion","adhesionFactorExpressionSlope")
measures<-c("Velocity","Displacement","PatchArea")
sample_maxes <- cbind(100,0.9,0.5,0.08,1,5)
sample_mins <-cbind(0,0.1,0.1,0.015,0.1,0.25)
partitionedData <- partition_dataset(sim_data_for_emulation, parameters,
measures, percent_train=75, percent_test=15, percent_validation=10, normalise=TRUE,
sample_mins = sample_mins, sample_maxes = sample_maxes)

}
