#
#
#   rescale.R
#
#   $Revision: 1.4 $ $Date: 2008/08/06 08:44:04 $
#
#

rescale <- function(X, s) {
  UseMethod("rescale")
}

rescale.ppp <- function(X, s) {
  Y <- affine.ppp(X, mat=diag(c(1/s,1/s)))
  unitname(Y) <- rescale(unitname(X), s)
  return(Y)
}

rescale.owin <- function(X, s) {
  Y <- affine.owin(X, mat=diag(c(1/s,1/s)))
  unitname(Y) <- rescale(unitname(X), s)
  return(Y)
}

rescale.im <- function(X, s) {
  Y <- X
  Y$xrange <- X$xrange/s
  Y$yrange <- X$yrange/s
  Y$xstep  <- X$xstep/s
  Y$ystep  <- X$ystep/s
  Y$xcol   <- X$xcol/s
  Y$yrow   <- X$yrow/s
  unitname(Y) <- rescale(unitname(X), s)
  return(Y)
}

rescale.psp <- function(X, s) {
  Y <- affine.psp(X, mat=diag(c(1/s,1/s)))
  unitname(Y) <- rescale(unitname(X), s)
  return(Y)
}
  
rescale.units <- function(X, s) {
  if(summary(X)$vanilla)
    return(X)
  if(!is.numeric(s) || length(s) != 1 || s <= 0)
    stop("s should be a positive number")
  X$multiplier <- s * X$multiplier
  return(X)
}


