% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_Methods_For_Class.R
\name{summary.spca}
\alias{summary.spca}
\title{Prints summaries from an spca object}
\usage{
\method{summary}{spca}(object, cols, perc = TRUE, rtn = FALSE, prn = TRUE,
  thrsehcard = 0.001, ...)
}
\arguments{
\item{object}{An spca object.}

\item{cols}{A vector indicating which components should be included. Default
all.  If an iteger is passed, it is set to 1:cols.}

\item{perc}{Logical: should the laodings be standardised to unit L1 norm
(and printed as percentage contributions)}

\item{rtn}{Logical: should the summary matrix of summaries be returneded?}

\item{prn}{Logical: should anything be printed? Takes priority on prnload.}

\item{thrsehcard}{Value below which loadings are considered zero and not
counted in the cardinality}

\item{...}{Additonal arguments for generic summary, additional arguments will
generate an error.}
}
\value{
If rtn = TRUE, a numerical matrix with the summaries.
}
\description{
Prints summaries and comparisons with the full PCA solutions for a set of LS
SPCA loadings.
}
\details{
The summaries are printed as formatted text, if rtn = TRUE, the value
returned is a numerical matrix.

For each component the following summaries are computed: \tabular{ll}{
PVE\tab The percentage variance explained\cr
PCVE \tab The percentage cumulative variance explained\cr
PRCVE \tab The percentage cumulative variance explained relative to that of the corresponding principal components\cr
Card \tab The cardinality, that is the number of non zero loadings\cr
Ccard \tab The cumulative cardinality.\cr
PVE/Card \tab The percentage variance explained over the cardinality.\cr
PCVE/Ccard \tab The percentage cumulative variance explained over the cumulative cardinality.\cr
Converged \tab If the object was computed with \emph{spcabe}, type of convergence: 0 if all loadings bigger than \emph{thresh}, 1 if minimal cardinality reached or 2 if the maximal variance loss in trimming was reached.\cr
MinLoad \tab Minimum absolute value of the non-zero loadings. }
If perc = TRUE, the last row gives the minimum absolute percentage contribution, MinPContr.
}
\note{
This is a wrapper for the main function in which the "dots" are disabled
so that only exact (or partial) prescribed arguments can be entered.
}
\seealso{
Examples in \link{spcabe} and \link{spcabb}
}

