% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hClustAlign.R
\name{hClustAlign}
\alias{hClustAlign}
\title{CluPA function for two spectra.}
\usage{
hClustAlign(refSpec, tarSpec, peakList, peakLabel, startP, endP,
  distanceMethod = "average", maxShift = 0, acceptLostPeak = FALSE)
}
\arguments{
\item{refSpec}{The reference spectrum.}

\item{tarSpec}{The target spectrum.}

\item{peakList}{List of peaks of the both reference and target spectra}

\item{peakLabel}{The list of the labels of the peaks}

\item{startP}{The starting point of the segment.}

\item{endP}{The ending point of the segment.}

\item{distanceMethod}{The distance method for the hierarchial clustering algorithm.}

\item{maxShift}{The maximum number of points for a shift step.}

\item{acceptLostPeak}{This is an option for users, TRUE is the default value. If the users believe that all the peaks in the peak list are true positive, change it to FALSE.}
}
\value{
list of 2: tarSpec (The target spectrum after alignment) and peakList (The peak list after alignment)
}
\description{
This function implements the idea of the CluPA algorithm to align the target spectrum against the reference spectrum.
}
\examples{
res=makeSimulatedData();
X=res$data;
groupLabel=res$label;
peakList <- detectSpecPeaks(X,
                            nDivRange = c(128),
                            scales = seq(1, 16, 2),
                            baselineThresh = 50000,
                            SNR.Th = -1,
                            verbose=FALSE
);
resFindRef<- findRef(peakList);
refInd <- resFindRef$refInd;
tarInd=1;
refSpec=X[refInd,];
tarSpec=X[tarInd,];
mergedPeakList=c(peakList[[refInd]],peakList[[tarInd]]);
mergedPeakLabel=double(length(mergedPeakList));
for (i in 1:length(peakList[[refInd]]) ) mergedPeakLabel[i]=1;
startP=1;
endP=length(tarSpec);
res=hClustAlign(refSpec,tarSpec,mergedPeakList,mergedPeakLabel,startP,endP,
                maxShift=50,acceptLostPeak=TRUE)
                       
}
\references{
Vu TN, Valkenborg D, Smets K, Verwaest KA, Dommisse R, Lemi\`{e}re F, Verschoren A, Goethals B, Laukens K. (2011) An integrated workflow for robust alignment and simplified quantitative analysis of NMR spectrometry data. BMC Bioinformatics. 2011 Oct 20;12:405.
}
\seealso{
\code{\link{dohCluster}}
}
\author{
Trung Nghia Vu
}
