% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-methods.R
\docType{methods}
\name{mutate}
\alias{mutate}
\alias{mutate.Spectra}
\alias{mutate,Spectra-method}
\title{Mutate a Spectra* object by transforming the spectra values, and/or adding
new or replacing existing attributes.}
\usage{
\S4method{mutate}{Spectra}(.data, ...)
}
\arguments{
\item{.data}{an object inheriting from the \code{Spectra} class}

\item{...}{named parameters giving definitions of new columns}
}
\description{
This function is very similar to \code{transform} but it executes the
transformations iteratively so that later transformations can use the
columns created by earlier transformations. Like transform, unnamed
components are silently dropped.

Either the spectra, and/or the attributes (if the \code{.data} inherits from
the \code{SpectraDataFrame} class) can be affected: \itemize{ \item To
affect the spectra, one should use the \code{nir} placeholder, eg \code{nir
= log(1/nir)} \item To affect the attributes of the object, the definitions
of new columns are simply given using attributes names, \code{newAttribute =
1/sqrt(attribute)} \item Both spectra and attrbutes can be transformed in
one command.}
}
\examples{

# Loading example data
data(australia)
spectra(australia) <- sr_no ~ ... ~ 350:2500

# Modifying spectra
m <- mutate(australia, nir = log1p(1/nir))
plot(m)

# Modifying and creating attributes
m <- mutate(
  australia, 
  sqrt_carbon = sqrt(carbon), 
  foo = clay + ph, 
  nir = log1p(1/nir)
)
plot(m)
}
\references{
Hadley Wickham (2011). The Split-Apply-Combine Strategy for Data
Analysis. Journal of Statistical Software, 40(1), 1-29. URL
http://www.jstatsoft.org/v40/i01/.
}
\author{
Pierre Roudier \email{pierre.roudier@gmail.com}, from code from
Hadley Wickham
}
