% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting.R
\docType{methods}
\name{subset-methods}
\alias{subset-methods}
\alias{[,SpectraInTime-method}
\alias{[,SpectraInTime,ANY,ANY,ANY-method}
\alias{[,SpectraInTime,ANY,ANY-method}
\alias{[,SpectraInTime,missing,ANY-method}
\alias{[,SpectraInTime,ANY,missing-method}
\alias{[,SpectraInTime,missing,missing-method}
\alias{[,SpectraInTime,missing,ANY,ANY-method}
\alias{[,SpectraInTime,ANY,missing,ANY-method}
\alias{[,SpectraInTime,missing,missing,ANY-method}
\title{Subsetting  \code{\link{SpectraInTime-class}}}
\usage{
\S4method{[}{SpectraInTime,ANY,ANY,ANY}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTime,missing,ANY,ANY}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTime,ANY,missing,ANY}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTime,missing,missing,ANY}(x, i, j, ..., drop = "")
}
\arguments{
\item{x}{object to subset}

\item{i}{subsetting rows ( timePoints )}

\item{j}{subsetting columns ( wavelengths )}

\item{...}{additional parameters 
  \itemize{
     \item timeUnit unit at which subsetting should be done choose between \code{seconds} , \code{minutes} or \code{hours} 
defaults to \code{seconds}
     \item   timePointsAlt logical indicators whater alternative timePoints should be used 
}}

\item{drop}{for consistancy, not used}
}
\description{
Subsetting  \code{\link{SpectraInTime-class}}
}
\examples{
 ### subsetting [ time , wavelength, options ]

 spectralEx                <-  getSpectraInTimeExample()
 spectraSubset             <-  spectralEx[ r( 1000 , 30000 ) , r(130 , 135 ) ]
 spectraSubsetTime         <-  spectralEx[ r( 1000 , 30000 ) ,  ]
 spectraSubsetWavelengths  <-  spectralEx[  ,  r(130 , 135 ) ]
 spectraSubsetHours        <-  spectralEx[ r( 1 , 3 ) , r(130 , 135 ) , timeUnit = "hours" ]
 closestWavelengths        <-  spectralEx[ , e( 150, 4, 300, 500 ) ] # remark only unique values 
 spectraSubsetLogical      <-  spectralEx[ getTimePoints( spectralEx ) > 300   ,
    getWavelengths( spectralEx ) <= 500 ]
}
