% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters_and_setters.R
\name{[<-.spectra}
\alias{[<-.spectra}
\title{Assign value values to spectra}
\usage{
\method{[}{spectra}(x, i, j) <- value
}
\arguments{
\item{x}{spectra object (lhs)}

\item{i}{Sample names (preferred), index, or a logical vector of length nrow(x)}

\item{j}{band labels, as numeric or character
or a logical vector of length ncol(x). Do not use indexes!}

\item{value}{value to be assigned (rhs). Must either data coercible to numeric
or another `spectra` obj}
}
\value{
nothing. modifies spectra as side effect
}
\description{
\code{`[<-`} assigns the rhs values to spectra
}
\examples{
library(spectrolab)
spec = as.spectra(spec_matrix_example, name_idx = 1)
spec[ , 400:500] = spec[ , 400:500] * 1.2
spec
}
\author{
Jose Eduardo Meireles
}
