/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard;

import at.ac.ait.speedr.importwizard.WizardIterator;
import at.ac.ait.speedr.importwizard.WizardValidationException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rosuda.REngine.REXPGenericVector;

public class WizardPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(WizardPanel.class.getName());
    public static final String PROP_STATE_CHANGED = "WizardPanel_stateChanged";
    public static final String PROP_STATE_FINISHED = "WizardPanel_stateFinished";
    public static final String PROP_STATE_NEXT = "WizardPanel_statenext";
    public static final String PROP_STATE_CANCELED = "WizardPanel_stateCanceled";
    public static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    public static final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    public static final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private static final int MSG_TYPE_ERROR = 1;
    private static final int MSG_TYPE_WARNING = 2;
    private static final int MSG_TYPE_INFO = 3;
    private static ImageIcon errorIcon;
    private static ImageIcon warningIcon;
    private static ImageIcon infoIcon;
    private static final Color errorForeground;
    private static final Color warningForeground;
    private static final Color infoForeground;
    private JLabel messageLabel = new JLabel();
    private HashMap<String, Object> properties = new HashMap(7);
    private WizardIterator iterator;
    private volatile REXPGenericVector dataframe;
    private boolean isValid = false;
    private boolean isBusy = false;
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            WizardPanel.this.checkValid();
            WizardPanel.this.updateButtons();
        }
    };
    private JButton backbutton;
    private JButton cancelbutton;
    private JPanel feedbackpanel;
    private JButton finishbutton;
    private JButton nextbutton;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JPanel progresspanel;
    private JPanel stepspanel;

    public WizardPanel(WizardIterator iterator) {
        this.initComponents();
        this.iterator = iterator;
        this.initialize();
    }

    private void initialize() {
        this.iterator.initialize(this);
        if (this.iterator.hasNext()) {
            this.nextbutton.setEnabled(this.isValid);
            this.finishbutton.setEnabled(false);
            this.setUpStep();
        }
        this.feedbackpanel.add((Component)this.messageLabel, "Center");
    }

    private void setUpStep() {
        this.stepspanel.removeAll();
        this.iterator.current().addChangeListener(this.changeListener);
        this.iterator.current().readSettings(this);
        this.stepspanel.add((Component)this.iterator.current().getComponent(), "Center");
        this.stepspanel.revalidate();
        this.stepspanel.repaint();
    }

    private void updateButtons() {
        this.nextbutton.setEnabled(this.isValid && !this.isBusy && this.iterator.hasNext());
        this.finishbutton.setEnabled(this.isValid && !this.isBusy && !this.iterator.hasNext());
        this.backbutton.setEnabled(this.iterator.hasPrevious() && !this.isBusy);
    }

    private void checkValid() {
        this.isValid = this.iterator.current().isValid();
    }

    public REXPGenericVector getDataframe() {
        return this.dataframe;
    }

    public synchronized Object getProperty(String name) {
        return this.properties.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(final String name, final Object value) {
        Object oldValue;
        WizardPanel wizardPanel = this;
        synchronized (wizardPanel) {
            oldValue = this.properties.get(name);
            this.properties.put(name, value);
        }
        this.firePropertyChange(name, oldValue, value);
        if (PROP_ERROR_MESSAGE.equals(name)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (WizardPanel.this.nextbutton.isEnabled() || WizardPanel.this.finishbutton.isEnabled()) {
                        WizardPanel.this.setMessage(2, (String)(value == null ? "" : value));
                    } else {
                        WizardPanel.this.setMessage(1, (String)(value == null ? "" : value));
                    }
                }
            });
        }
        if (PROP_WARNING_MESSAGE.equals(name) || PROP_INFO_MESSAGE.equals(name)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (WizardPanel.PROP_WARNING_MESSAGE.equals(name)) {
                        WizardPanel.this.setMessage(2, (String)(value == null ? "" : value));
                    } else {
                        WizardPanel.this.setMessage(3, (String)(value == null ? "" : value));
                    }
                }
            });
        }
    }

    public void setMessage(int msgType, String msg) {
        if (msg != null && msg.trim().length() > 0) {
            switch (msgType) {
                case 1: {
                    this.prepareMessage(this.messageLabel, WizardPanel.getErrorMessageIcon(), errorForeground);
                    break;
                }
                case 2: {
                    this.prepareMessage(this.messageLabel, WizardPanel.getWarningMessageIcon(), warningForeground);
                    break;
                }
                case 3: {
                    this.prepareMessage(this.messageLabel, WizardPanel.getInfoMessageIcon(), infoForeground);
                    break;
                }
            }
            this.messageLabel.setToolTipText(msg);
        } else {
            this.prepareMessage(this.messageLabel, null, null);
            this.messageLabel.setToolTipText(null);
        }
        this.messageLabel.setText(msg);
        this.feedbackpanel.removeAll();
        this.feedbackpanel.add((Component)this.messageLabel, "Center");
        this.feedbackpanel.validate();
        this.feedbackpanel.repaint();
    }

    private void prepareMessage(JLabel label, ImageIcon icon, Color fgColor) {
        label.setIcon(icon);
        label.setForeground(fgColor);
    }

    private static ImageIcon getErrorMessageIcon() {
        if (errorIcon == null) {
            errorIcon = WizardPanel.getIcon("/at/ac/ait/speedr/icons/error.gif");
        }
        return errorIcon;
    }

    private static ImageIcon getWarningMessageIcon() {
        if (warningIcon == null) {
            warningIcon = WizardPanel.getIcon("/at/ac/ait/speedr/icons/warning.gif");
        }
        return warningIcon;
    }

    private static ImageIcon getInfoMessageIcon() {
        if (infoIcon == null) {
            infoIcon = WizardPanel.getIcon("/at/ac/ait/speedr/icons/info.png");
        }
        return infoIcon;
    }

    private static ImageIcon getIcon(String img) {
        return new ImageIcon(WizardPanel.class.getResource(img));
    }

    private void initComponents() {
        this.progresspanel = new JPanel();
        this.progressLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelbutton = new JButton();
        this.finishbutton = new JButton();
        this.nextbutton = new JButton();
        this.backbutton = new JButton();
        this.feedbackpanel = new JPanel();
        this.stepspanel = new JPanel();
        this.progressLabel.setText("Please wait");
        GroupLayout progresspanelLayout = new GroupLayout(this.progresspanel);
        this.progresspanel.setLayout(progresspanelLayout);
        progresspanelLayout.setHorizontalGroup(progresspanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progresspanelLayout.createSequentialGroup().addComponent(this.progressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 132, -2)));
        progresspanelLayout.setVerticalGroup(progresspanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progresspanelLayout.createSequentialGroup().addGroup(progresspanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressLabel).addComponent(this.progressBar, -2, -1, -2)).addContainerGap()));
        this.cancelbutton.setText("Cancel");
        this.cancelbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardPanel.this.cancelbuttonActionPerformed(evt);
            }
        });
        this.finishbutton.setText("Finish");
        this.finishbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardPanel.this.finishbuttonActionPerformed(evt);
            }
        });
        this.nextbutton.setText("Next >");
        this.nextbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardPanel.this.nextbuttonActionPerformed(evt);
            }
        });
        this.backbutton.setText("< Back");
        this.backbutton.setEnabled(false);
        this.backbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardPanel.this.backbuttonActionPerformed(evt);
            }
        });
        this.feedbackpanel.setLayout(new BorderLayout());
        this.stepspanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.feedbackpanel, -1, 114, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.backbutton, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextbutton, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishbutton, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelbutton, -2, 82, -2).addGap(6, 6, 6)).addComponent(this.stepspanel, -1, 459, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.stepspanel, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.feedbackpanel, -2, 26, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelbutton, -2, 26, -2).addComponent(this.finishbutton, -2, 26, -2).addComponent(this.nextbutton, -2, 26, -2).addComponent(this.backbutton, -2, 26, -2)))));
    }

    private void backbuttonActionPerformed(ActionEvent evt) {
        if (this.iterator.current() instanceof ProgressStep) {
            ((ProgressStep)this.iterator.current()).stopProcessing();
        }
        this.iterator.current().storeSettings(this);
        this.iterator.current().removeChangeListener(this.changeListener);
        this.iterator.previousPanel();
        this.setUpStep();
        this.updateButtons();
    }

    private void nextbuttonActionPerformed(ActionEvent evt) {
        this.iterator.current().storeSettings(this);
        this.iterator.current().removeChangeListener(this.changeListener);
        this.iterator.nextStep();
        this.setUpStep();
        if (this.iterator.current() instanceof ProgressStep) {
            final ProgressStep step = (ProgressStep)this.iterator.current();
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    step.startProcessing();
                    return null;
                }

                protected void done() {
                    WizardPanel.this.displayProgress(false);
                    WizardPanel.this.checkValid();
                    WizardPanel.this.updateButtons();
                }
            };
            this.displayProgress(true);
            worker.execute();
            this.checkValid();
            this.updateButtons();
            this.firePropertyChange(PROP_STATE_CHANGED, null, PROP_STATE_NEXT);
        }
    }

    private void finishbuttonActionPerformed(ActionEvent evt) {
        this.iterator.current().storeSettings(this);
        logger.log(Level.INFO, "finish action entry");
        this.isBusy = true;
        this.updateButtons();
        if (this.iterator.current() instanceof ValidatingStep) {
            ValidatingStep vstep = (ValidatingStep)this.iterator.current();
            try {
                vstep.validate();
                this.displayProgress(true);
                new Thread(new Runnable(){

                    public void run() {
                        WizardPanel.this.dataframe = WizardPanel.this.iterator.instantiate();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                WizardPanel.this.firePropertyChange(WizardPanel.PROP_STATE_CHANGED, null, WizardPanel.PROP_STATE_FINISHED);
                                WizardPanel.this.callUnininitialize();
                            }
                        });
                    }
                }).start();
            }
            catch (WizardValidationException ex) {
                this.setMessage(1, ex.getMessage());
                this.isBusy = false;
                this.updateButtons();
                return;
            }
        }
    }

    private void cancelbuttonActionPerformed(ActionEvent evt) {
        if (this.iterator.current() instanceof ProgressStep) {
            ((ProgressStep)this.iterator.current()).stopProcessing();
        }
        this.isBusy = false;
        this.updateButtons();
        this.firePropertyChange(PROP_STATE_CHANGED, null, PROP_STATE_CANCELED);
        this.callUnininitialize();
    }

    public void callUnininitialize() {
        if (this.iterator != null) {
            this.iterator.current().removeChangeListener(this.changeListener);
            this.iterator.uninitialize(this);
            this.iterator = null;
        }
        this.stepspanel.removeAll();
    }

    public void displayProgress(boolean visible) {
        if (visible) {
            this.isBusy = true;
            this.feedbackpanel.removeAll();
            this.progressLabel.setText("Please wait");
            this.progressBar.setIndeterminate(true);
            this.feedbackpanel.add((Component)this.progresspanel, "Center");
        } else {
            this.isBusy = false;
            this.progressLabel.setText("Finished");
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            Timer t = new Timer(5000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (WizardPanel.this.feedbackpanel.getComponentCount() > 0 && WizardPanel.this.feedbackpanel.getComponent(0) == WizardPanel.this.progresspanel) {
                        WizardPanel.this.feedbackpanel.removeAll();
                        WizardPanel.this.feedbackpanel.revalidate();
                        WizardPanel.this.feedbackpanel.repaint();
                    }
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    public void doNextClick() {
        this.nextbutton.doClick();
    }

    public void doFinishClick() {
        this.finishbutton.doClick();
    }

    public boolean isFinishEnabled() {
        return this.finishbutton.isEnabled();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame f = new JFrame();
                f.setBounds(100, 100, 800, 600);
                f.setDefaultCloseOperation(3);
                f.setContentPane(new WizardPanel(new WizardIterator()));
                f.setVisible(true);
            }
        });
    }

    public void setDataframeToNull() {
        if (this.dataframe == null) {
            logger.log(Level.INFO, "dataframe is alread null!");
        }
        this.dataframe = null;
    }

    static {
        errorForeground = new Color(255, 0, 0);
        warningForeground = new Color(51, 51, 51);
        infoForeground = UIManager.getColor("Label.foreground");
    }

    public static interface ProgressStep
    extends Step {
        public void startProcessing();

        public void stopProcessing();
    }

    public static interface ValidatingStep
    extends Step {
        public void validate() throws WizardValidationException;
    }

    public static interface Step {
        public JPanel getComponent();

        public void readSettings(WizardPanel var1);

        public void storeSettings(WizardPanel var1);

        public boolean isValid();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

