/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CControlFactory;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.DefaultCControlRegister;
import bibliothek.gui.dock.common.intern.MutableCControlRegister;
import bibliothek.gui.dock.common.intern.station.CSplitDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.util.WindowProvider;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EfficientControlFactory
implements CControlFactory {
    @Override
    public DockController createController(final CControl cControl) {
        return new DockController(){

            public void setFocusedDockable(Dockable dockable, boolean bl, boolean bl2) {
                CLocationModeManager cLocationModeManager;
                if (dockable != null && (cLocationModeManager = cControl.getLocationManager()) != null && !cLocationModeManager.isOnTransaction()) {
                    cLocationModeManager.ensureNotHidden(dockable);
                }
                super.setFocusedDockable(dockable, bl, bl2);
            }
        };
    }

    @Override
    public CDockFrontend createFrontend(CControlAccess cControlAccess, DockController dockController) {
        return new CDockFrontend(cControlAccess, dockController);
    }

    @Override
    public MutableCControlRegister createRegister(CControl cControl) {
        return new DefaultCControlRegister(cControl);
    }

    @Override
    public FlapDockStation createFlapDockStation(final Component component) {
        return new FlapDockStation(){

            public Rectangle getExpansionBounds() {
                Point point = new Point(0, 0);
                point = SwingUtilities.convertPoint(this.getComponent(), point, component);
                return new Rectangle(-point.x, -point.y, component.getWidth(), component.getHeight());
            }
        };
    }

    @Override
    public ScreenDockStation createScreenDockStation(WindowProvider windowProvider) {
        ScreenDockStation screenDockStation = new ScreenDockStation(windowProvider){

            protected ListeningDockAction createFullscreenAction() {
                return null;
            }
        };
        screenDockStation.setExpandOnDoubleClick(false);
        return screenDockStation;
    }

    @Override
    public SplitDockStation createSplitDockStation() {
        return new SplitDockStation(){

            protected ListeningDockAction createFullScreenAction() {
                return null;
            }

            public void setFrontDockable(Dockable dockable) {
                if (!this.isFullScreen()) {
                    super.setFrontDockable(dockable);
                }
            }
        };
    }

    @Override
    public CommonStation<SplitDockStation> createSplitDockStation(CommonStationDelegate commonStationDelegate) {
        return new CSplitDockStation(commonStationDelegate);
    }
}

