/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.intern.color.TabColorTransmitter;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;

public class FlatTabTransmitter
extends TabColorTransmitter {
    private static final String[] KEYS = new String[]{"stack.tab.border.out.selected", "stack.tab.border.center.selected", "stack.tab.border.out.focused", "stack.tab.border.center.focused", "stack.tab.border.out", "stack.tab.border.center", "stack.tab.background.top.selected", "stack.tab.background.bottom.selected", "stack.tab.background.top.focused", "stack.tab.background.bottom.focused", "stack.tab.background.top", "stack.tab.background.bottom", "stack.tab.foreground.selected", "stack.tab.foreground.focused", "stack.tab.foreground"};

    public FlatTabTransmitter(ColorManager colorManager) {
        super(colorManager, KEYS);
    }

    protected Color convert(Color color, String string) {
        if (string.contains("focused")) {
            return this.convertFocused(Colors.diffMirror(color, 0.6), string);
        }
        if (string.contains("selected")) {
            return this.convertSelected(Colors.diffMirror(color, 0.3), string);
        }
        if ("stack.tab.border.out".equals(string)) {
            return null;
        }
        if ("stack.tab.border.center".equals(string)) {
            return null;
        }
        if ("stack.tab.background.top".equals(string)) {
            return Colors.darker(color, 0.3);
        }
        if ("stack.tab.background.bottom".equals(string)) {
            return Colors.brighter(color, 0.3);
        }
        if ("stack.tab.foreground".equals(string)) {
            return Colors.diffMirror(color, 1.0);
        }
        return null;
    }

    protected Color convertSelected(Color color, String string) {
        if (string.contains("focused")) {
            return this.convertFocused(Colors.diffMirror(color, 0.3), string);
        }
        if ("stack.tab.border.out.selected".equals(string)) {
            return null;
        }
        if ("stack.tab.border.center.selected".equals(string)) {
            return null;
        }
        if ("stack.tab.background.top.selected".equals(string)) {
            return Colors.darker(color, 0.3);
        }
        if ("stack.tab.background.bottom.selected".equals(string)) {
            return Colors.brighter(color, 0.3);
        }
        if ("stack.tab.foreground.selected".equals(string)) {
            return Colors.diffMirror(color, 1.0);
        }
        return null;
    }

    protected Color convertFocused(Color color, String string) {
        if ("stack.tab.border.out.focused".equals(string)) {
            return null;
        }
        if ("stack.tab.border.center.focused".equals(string)) {
            return null;
        }
        if ("stack.tab.background.top.focused".equals(string)) {
            return Colors.darker(color, 0.3);
        }
        if ("stack.tab.background.bottom.focused".equals(string)) {
            return Colors.brighter(color, 0.3);
        }
        if ("stack.tab.foreground.focused".equals(string)) {
            return Colors.diffMirror(color, 1.0);
        }
        return null;
    }

    protected boolean isFocused(String string) {
        return string.contains("focused");
    }

    protected boolean isForeground(String string) {
        return string.contains("foreground");
    }

    protected boolean isSelected(String string) {
        return string.contains("selected");
    }
}

