/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.predefined.CExternalizeAction;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.ExternalizedModeArea;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.action.ExternalizedModeAction;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.NullModeSettingsFactory;
import bibliothek.gui.dock.support.util.Resources;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Point;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalizedMode<M extends ExternalizedModeArea>
extends DefaultLocationMode<M> {
    public static final Path IDENTIFIER = new Path("dock.mode.externalized");
    public static final String ICON_IDENTIFIER = "location.externalize";

    protected ExternalizedMode() {
    }

    public ExternalizedMode(CControl cControl) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new CExternalizeAction(cControl)));
    }

    public ExternalizedMode(DockController dockController) {
        IconManager iconManager = dockController.getIcons();
        iconManager.setIconDefault("externalize", Resources.getIcon("externalize"));
        this.setActionProvider(new DefaultLocationModeActionProvider(new ExternalizedModeAction(dockController, this)));
    }

    @Override
    public Path getUniqueIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public ExtendedMode getExtendedMode() {
        return ExtendedMode.EXTERNALIZED;
    }

    @Override
    public boolean isDefaultMode(Dockable dockable) {
        return false;
    }

    @Override
    public void runApply(Dockable dockable, Location location, AffectedSet affectedSet) {
        this.externalize(dockable, location, affectedSet);
    }

    private void externalize(Dockable dockable, Location location, AffectedSet affectedSet) {
        affectedSet.add(dockable);
        ExternalizedModeArea externalizedModeArea = null;
        if (location != null) {
            externalizedModeArea = (ExternalizedModeArea)this.get(location.getRoot());
        }
        if (externalizedModeArea == null) {
            externalizedModeArea = (ExternalizedModeArea)this.getDefaultArea();
        }
        DockableProperty dockableProperty = null;
        if (location != null) {
            dockableProperty = location.getLocation();
        }
        if (dockableProperty == null && !externalizedModeArea.isChild(dockable)) {
            Component component = dockable.getComponent();
            component.invalidate();
            Component component2 = component;
            while (component2.getParent() != null) {
                component2 = component2.getParent();
            }
            component2.validate();
            Point point = new Point();
            SwingUtilities.convertPointToScreen(point, dockable.getComponent());
            dockableProperty = new ScreenDockProperty(point.x, point.y, component.getWidth(), component.getHeight(), null, false);
        }
        externalizedModeArea.setLocation(dockable, dockableProperty, affectedSet);
    }

    @Override
    public ModeSettingFactory<Location> getSettingFactory() {
        return new NullModeSettingsFactory<Location>(this.getUniqueIdentifier());
    }

    @Override
    public void ensureNotHidden(Dockable dockable) {
    }

    @Override
    public void writeSetting(ModeSetting<Location> modeSetting) {
    }

    @Override
    public void readSetting(ModeSetting<Location> modeSetting) {
    }
}

