/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public abstract class FrontendSettingsList
extends BaseMenuPiece {
    private DockFrontend frontend;
    private Listener listener = new Listener();
    private Map<String, JRadioButtonMenuItem> items = new HashMap<String, JRadioButtonMenuItem>();

    public FrontendSettingsList(DockFrontend dockFrontend) {
        this.setFrontend(dockFrontend);
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public void setFrontend(DockFrontend dockFrontend) {
        if (this.frontend != dockFrontend) {
            if (this.frontend != null) {
                int n = this.getItemCount();
                while (n > 0) {
                    this.remove(--n);
                }
                this.items.clear();
                this.frontend.removeFrontendListener(this.listener);
            }
            this.frontend = dockFrontend;
            if (this.frontend != null) {
                this.frontend.addFrontendListener(this.listener);
                for (String string : dockFrontend.getSettings()) {
                    this.add(string);
                }
            }
        }
    }

    protected abstract void action(String var1);

    private void add(final String string) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrontendSettingsList.this.action(string);
                FrontendSettingsList.this.updateSelection();
            }
        });
        this.add(jRadioButtonMenuItem);
        this.items.put(string, jRadioButtonMenuItem);
        this.updateSelection();
    }

    private void remove(String string) {
        JMenuItem jMenuItem = this.items.remove(string);
        if (jMenuItem != null) {
            this.remove(jMenuItem);
            this.updateSelection();
        }
    }

    public void updateSelection() {
        String string = this.frontend.getCurrentSetting();
        for (Map.Entry<String, JRadioButtonMenuItem> entry : this.items.entrySet()) {
            entry.getValue().setSelected(entry.getKey().equals(string));
        }
    }

    private class Listener
    extends DockFrontendAdapter {
        private Listener() {
        }

        public void deleted(DockFrontend dockFrontend, String string) {
            FrontendSettingsList.this.remove(string);
        }

        public void saved(DockFrontend dockFrontend, String string) {
            if (!FrontendSettingsList.this.items.containsKey(string)) {
                FrontendSettingsList.this.add(string);
            } else {
                FrontendSettingsList.this.updateSelection();
            }
        }

        public void read(DockFrontend dockFrontend, String string) {
            if (!FrontendSettingsList.this.items.containsKey(string)) {
                FrontendSettingsList.this.add(string);
            } else {
                FrontendSettingsList.this.updateSelection();
            }
        }

        public void loaded(DockFrontend dockFrontend, String string) {
            FrontendSettingsList.this.updateSelection();
        }
    }
}

