/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreferenceModel;
import bibliothek.extension.gui.dock.preference.Preference;
import bibliothek.extension.gui.dock.preference.PreferenceListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPreferenceModel
extends AbstractPreferenceModel {
    private List<Entry<?>> entries = new ArrayList();

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public String getLabel(int n) {
        return this.getPreference(n).getLabel();
    }

    @Override
    public String getDescription(int n) {
        return this.getPreference(n).getDescription();
    }

    @Override
    public Object getValueInfo(int n) {
        return this.getPreference(n).getValueInfo();
    }

    @Override
    public Object getValue(int n) {
        return this.getPreference(n).getValue();
    }

    @Override
    public void setValue(int n, Object object) {
        this.getPreference(n).setValue(object);
    }

    @Override
    public Path getTypePath(int n) {
        return this.getPreference(n).getTypePath();
    }

    @Override
    public Path getPath(int n) {
        return this.getPreference(n).getPath();
    }

    @Override
    public boolean isNatural(int n) {
        return this.getPreference(n).isNatural();
    }

    @Override
    public void setValueNatural(int n) {
        this.getPreference(n).read();
    }

    public Preference<?> getPreference(int n) {
        return this.entries.get(n).getPreference();
    }

    public void add(Preference<?> preference) {
        this.insert(this.entries.size(), preference);
    }

    public void insert(int n, Preference<?> preference) {
        if (preference == null) {
            throw new IllegalArgumentException("preference must not be null");
        }
        if (n < 0 || n > this.entries.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Path path = preference.getPath();
        for (Entry<?> entry : this.entries) {
            if (!entry.getPreference().getPath().equals(path)) continue;
            throw new IllegalArgumentException("there is already a preference with path " + path);
        }
        Entry<?> entry = new Entry(preference, n);
        this.entries.add(n, entry);
        int n2 = this.entries.size();
        for (int i = n + 1; i < n2; ++i) {
            this.entries.get(i).setIndex(i);
        }
        this.firePreferenceAdded(n, n);
    }

    public void remove(int n) {
        Entry<?> entry = this.entries.remove(n);
        entry.kill();
        int n2 = this.entries.size();
        for (int i = n; i < n2; ++i) {
            this.entries.get(i).setIndex(i);
        }
        this.firePreferenceRemoved(n, n);
    }

    public void remove(Preference<?> preference) {
        int n = this.indexOf(preference);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void removeAll() {
        int n = this.entries.size();
        if (n > 0) {
            for (Entry<?> entry : this.entries) {
                entry.kill();
            }
            this.entries.clear();
            this.firePreferenceRemoved(0, n - 1);
        }
    }

    public int indexOf(Preference<?> preference) {
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            if (this.entries.get(i).getPreference() != preference) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void read() {
        for (Entry<?> entry : this.entries) {
            entry.getPreference().read();
        }
    }

    @Override
    public void write() {
        for (Entry<?> entry : this.entries) {
            entry.getPreference().write();
        }
    }

    @Override
    public PreferenceOperation[] getOperations(int n) {
        return this.entries.get(n).getPreference().getOperations();
    }

    @Override
    public boolean isEnabled(int n, PreferenceOperation preferenceOperation) {
        return this.entries.get(n).getPreference().isEnabled(preferenceOperation);
    }

    @Override
    public void doOperation(int n, PreferenceOperation preferenceOperation) {
        this.entries.get(n).getPreference().doOperation(preferenceOperation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry<V>
    implements PreferenceListener<V> {
        private Preference<V> preference;
        private int index;

        public Entry(Preference<V> preference, int n) {
            this.preference = preference;
            this.index = n;
            preference.addPreferenceListener(this);
        }

        @Override
        public void changed(Preference<V> preference) {
            DefaultPreferenceModel.this.firePreferenceChanged(this.index, this.index);
        }

        public void kill() {
            this.preference.removePreferenceListener(this);
        }

        public Preference<V> getPreference() {
            return this.preference;
        }

        public void setIndex(int n) {
            this.index = n;
        }
    }
}

