/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreferenceModel;
import bibliothek.extension.gui.dock.preference.MergedPreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.util.Path;
import bibliothek.util.PathCombiner;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PreferenceTreeModel
extends AbstractPreferenceModel
implements TreeModel {
    private MergedPreferenceModel delegate;
    private PreferenceModelListener delegateListener = new PreferenceModelListener(){

        public void preferenceAdded(PreferenceModel preferenceModel, int n, int n2) {
            PreferenceTreeModel.this.firePreferenceAdded(n, n2);
        }

        public void preferenceChanged(PreferenceModel preferenceModel, int n, int n2) {
            PreferenceTreeModel.this.firePreferenceChanged(n, n2);
        }

        public void preferenceRemoved(PreferenceModel preferenceModel, int n, int n2) {
            PreferenceTreeModel.this.firePreferenceRemoved(n, n2);
        }
    };
    private List<TreeModelListener> treeListeners = new ArrayList<TreeModelListener>();
    private TreeNode root = new TreeNode(null, new Path());

    public PreferenceTreeModel() {
        this.delegate = new MergedPreferenceModel();
    }

    public PreferenceTreeModel(PathCombiner pathCombiner) {
        this.delegate = new MergedPreferenceModel(pathCombiner);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeListeners.add(treeModelListener);
    }

    public void addPreferenceModelListener(PreferenceModelListener preferenceModelListener) {
        boolean bl = this.hasListeners();
        super.addPreferenceModelListener(preferenceModelListener);
        if (!bl && this.hasListeners()) {
            this.delegate.addPreferenceModelListener(this.delegateListener);
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeListeners.remove(treeModelListener);
    }

    public void removePreferenceModelListener(PreferenceModelListener preferenceModelListener) {
        boolean bl = this.hasListeners();
        super.removePreferenceModelListener(preferenceModelListener);
        if (bl && !this.hasListeners()) {
            this.delegate.removePreferenceModelListener(this.delegateListener);
        }
    }

    protected TreeModelListener[] getTreeModelListeners() {
        return this.treeListeners.toArray(new TreeModelListener[this.treeListeners.size()]);
    }

    private void fireNodeAdded(TreeNode treeNode, TreeNode treeNode2) {
        TreeModelListener[] treeModelListenerArray = this.getTreeModelListeners();
        if (treeModelListenerArray.length > 0) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treeNode.getTreePath(), new int[]{treeNode.indexOf(treeNode2)}, new Object[]{treeNode2});
            for (TreeModelListener treeModelListener : treeModelListenerArray) {
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }
    }

    private void fireNodeChanged(TreeNode treeNode) {
        TreeModelListener[] treeModelListenerArray = this.getTreeModelListeners();
        if (treeModelListenerArray.length > 0) {
            TreeNode treeNode2 = treeNode.getParent();
            TreeModelEvent treeModelEvent = treeNode2 == null ? new TreeModelEvent((Object)this, treeNode.getTreePath()) : new TreeModelEvent((Object)this, treeNode.getTreePath(), new int[]{treeNode2.indexOf(treeNode)}, new Object[]{treeNode});
            for (TreeModelListener treeModelListener : treeModelListenerArray) {
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
        }
    }

    private void fireNodeRemoved(TreeNode treeNode, int[] nArray, Object[] objectArray) {
        TreeModelListener[] treeModelListenerArray = this.getTreeModelListeners();
        if (treeModelListenerArray.length > 0) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treeNode.getTreePath(), nArray, objectArray);
            for (TreeModelListener treeModelListener : treeModelListenerArray) {
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
        }
    }

    public Node getChild(Object object, int n) {
        return ((TreeNode)object).getChild(n);
    }

    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildrenCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeNode)object).indexOf((TreeNode)object2);
    }

    public Node getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        return ((TreeNode)object).getChildrenCount() == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public String getDescription(int n) {
        return this.delegate.getDescription(n);
    }

    public boolean isNatural(int n) {
        return this.delegate.isNatural(n);
    }

    public void setValueNatural(int n) {
        this.delegate.setValueNatural(n);
    }

    public PreferenceOperation[] getOperations(int n) {
        return this.delegate.getOperations(n);
    }

    public boolean isEnabled(int n, PreferenceOperation preferenceOperation) {
        return this.delegate.isEnabled(n, preferenceOperation);
    }

    public void doOperation(int n, PreferenceOperation preferenceOperation) {
        this.delegate.doOperation(n, preferenceOperation);
    }

    public void read() {
        this.delegate.read();
    }

    public void write() {
        this.delegate.write();
    }

    public String getLabel(int n) {
        return this.delegate.getLabel(n);
    }

    public Path getPath(int n) {
        return this.delegate.getPath(n);
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public Path getTypePath(int n) {
        return this.delegate.getTypePath(n);
    }

    public Object getValueInfo(int n) {
        return this.delegate.getValueInfo(n);
    }

    public Object getValue(int n) {
        return this.delegate.getValue(n);
    }

    public void setValue(int n, Object object) {
        this.delegate.setValue(n, object);
    }

    public void putNode(Path path, String string) {
        this.root.getNode(path, 0).setName(string);
    }

    public void putModel(Path path, PreferenceModel preferenceModel) {
        this.root.getNode(path, 0).setModel(preferenceModel);
        this.delegate.remove(path);
        this.delegate.add(preferenceModel, path);
    }

    public void put(Path path, String string, PreferenceModel preferenceModel) {
        this.delegate.remove(path);
        if (preferenceModel != null) {
            this.delegate.add(preferenceModel, path);
        }
        this.root.getNode(path, 0).set(string, preferenceModel);
    }

    public void delete(Path path) {
        this.root.delete(path, 0);
    }

    private class TreeNode
    implements Node {
        private TreeNode parent;
        private List<TreeNode> children;
        private Path path;
        private TreePath treePath;
        private String name;
        private PreferenceModel model;

        public TreeNode(TreeNode treeNode, Path path) {
            this.parent = treeNode;
            this.path = path;
        }

        public int getChildrenCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public TreeNode getChild(int n) {
            return this.children.get(n);
        }

        public int indexOf(TreeNode treeNode) {
            return this.children.indexOf(treeNode);
        }

        public TreePath getTreePath() {
            if (this.treePath != null) {
                return this.treePath;
            }
            this.treePath = this.parent == null ? new TreePath(this) : this.parent.getTreePath().pathByAddingChild(this);
            return this.treePath;
        }

        public TreeNode getNode(Path path, int n) {
            if (n == path.getSegmentCount()) {
                return this;
            }
            if (this.children == null) {
                this.children = new ArrayList<TreeNode>();
            }
            String string = path.getSegment(n);
            for (TreeNode treeNode : this.children) {
                if (!string.equals(treeNode.getPath().getLastSegment())) continue;
                return treeNode.getNode(path, n + 1);
            }
            TreeNode treeNode = new TreeNode(this, path.subPath(0, n + 1));
            this.children.add(treeNode);
            PreferenceTreeModel.this.fireNodeAdded(this, treeNode);
            return treeNode.getNode(path, n + 1);
        }

        public void delete(Path path, int n) {
            if (n == path.getSegmentCount()) {
                this.delete(false);
            } else if (this.children != null) {
                String string = path.getSegment(n);
                for (TreeNode treeNode : this.children) {
                    if (!string.equals(treeNode.getPath().getLastSegment())) continue;
                    treeNode.delete(path, n + 1);
                    break;
                }
            }
        }

        public void delete(boolean bl) {
            if (this.children != null) {
                for (TreeNode treeNode : this.children) {
                    treeNode.delete(true);
                }
            }
            if (!bl) {
                if (this.parent == null) {
                    if (this.children != null) {
                        Object object = new int[this.children.size()];
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            object[i] = i;
                        }
                        Object[] objectArray = this.children.toArray();
                        this.children.clear();
                        PreferenceTreeModel.this.fireNodeRemoved(this, (int[])object, objectArray);
                    }
                } else {
                    this.parent.delete(this);
                }
            }
        }

        public void delete(TreeNode treeNode) {
            int n = this.indexOf(treeNode);
            this.children.remove(n);
            PreferenceTreeModel.this.fireNodeRemoved(this, new int[]{n}, new Object[]{treeNode});
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public String toString() {
            return this.name == null ? "" : this.name;
        }

        public Path getPath() {
            return this.path;
        }

        public void set(String string, PreferenceModel preferenceModel) {
            this.name = string;
            this.model = preferenceModel;
            PreferenceTreeModel.this.fireNodeChanged(this);
        }

        public void setName(String string) {
            this.name = string;
            PreferenceTreeModel.this.fireNodeChanged(this);
        }

        public String getName() {
            return this.name;
        }

        public void setModel(PreferenceModel preferenceModel) {
            this.model = preferenceModel;
            PreferenceTreeModel.this.fireNodeChanged(this);
        }

        public PreferenceModel getModel() {
            return this.model;
        }
    }

    public static interface Node {
        public Path getPath();

        public String getName();

        public PreferenceModel getModel();
    }
}

