/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.editor;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.preferences.choice.Choice;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceEditor
extends JComboBox
implements PreferenceEditor<String> {
    public static final PreferenceEditorFactory<String> FACTORY = new PreferenceEditorFactory<String>(){

        @Override
        public PreferenceEditor<String> create() {
            return new ChoiceEditor();
        }
    };
    private DefaultComboBoxModel model;
    private Choice choice;
    private boolean onChange = false;
    private PreferenceEditorCallback<String> callback;

    public ChoiceEditor() {
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!ChoiceEditor.this.onChange && itemEvent.getStateChange() == 1) {
                    if (ChoiceEditor.this.callback != null) {
                        ChoiceEditor.this.callback.set(ChoiceEditor.this.getValue());
                    }
                    ChoiceEditor.this.checkOperations();
                }
            }
        });
    }

    @Override
    public void setValueInfo(Object object) {
        this.choice = object instanceof Choice ? (Choice)object : null;
        this.model = new DefaultComboBoxModel();
        if (this.choice != null) {
            if (this.choice.isNullEntryAllowed()) {
                this.model.addElement(new Entry(null, ""));
            }
            int n = this.choice.size();
            for (int i = 0; i < n; ++i) {
                this.model.addElement(new Entry(this.choice.getId(i), this.choice.getText(i)));
            }
        }
        this.setModel(this.model);
        this.checkOperations();
    }

    @Override
    public void doOperation(PreferenceOperation preferenceOperation) {
        if (preferenceOperation == PreferenceOperation.DEFAULT) {
            this.setValue(this.choice.getDefaultChoice());
            if (this.callback != null) {
                this.callback.set(this.getValue());
            }
        }
        if (preferenceOperation == PreferenceOperation.DELETE) {
            this.setValue(null);
            if (this.callback != null) {
                this.callback.set(null);
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getValue() {
        return ((Entry)this.model.getSelectedItem()).id;
    }

    @Override
    public void setCallback(PreferenceEditorCallback<String> preferenceEditorCallback) {
        this.callback = preferenceEditorCallback;
        this.checkOperations();
    }

    private void checkOperations() {
        if (this.callback != null && this.choice != null) {
            String string;
            if (this.choice.isNullEntryAllowed()) {
                this.callback.setOperation(PreferenceOperation.DELETE, this.getValue() != null);
            }
            boolean bl = (string = this.getValue()) == null && this.choice.getDefaultChoice() != null || string != null && !string.equals(this.choice.getDefaultChoice());
            this.callback.setOperation(PreferenceOperation.DEFAULT, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String string) {
        try {
            this.onChange = true;
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                Entry entry = (Entry)this.model.getElementAt(i);
                if (entry.id != string && (string == null || !string.equals(entry.id))) continue;
                this.model.setSelectedItem(entry);
                break;
            }
        }
        finally {
            this.onChange = false;
            this.checkOperations();
        }
    }

    private static class Entry {
        public String id;
        public String text;

        public Entry(String string, String string2) {
            this.id = string;
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }
}

