/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.dockable.TrueMovingImage;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.AWTComponentCaptureStrategy;
import bibliothek.gui.dock.util.DockSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ScreencaptureMovingImageFactory
implements DockableMovingImageFactory {
    private Dimension max;

    public ScreencaptureMovingImageFactory(Dimension dimension) {
        this.max = dimension;
    }

    public MovingImage create(DockController dockController, DockTitle dockTitle) {
        return this.create(dockController, dockTitle.getDockable());
    }

    public BufferedImage createImageFrom(DockController dockController, Dockable dockable) {
        Object object;
        Component component = dockable.getComponent();
        Dimension dimension = new Dimension(Math.max(1, component.getWidth()), Math.max(1, component.getHeight()));
        BufferedImage bufferedImage = null;
        if (dimension.width >= 10 && dimension.height >= 10) {
            double d;
            if (DockSwingUtilities.containsAWTComponents(component)) {
                bufferedImage = dockController.getProperties().get(AWTComponentCaptureStrategy.STRATEGY).createCapture(dockController, component);
            } else {
                bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
                object = bufferedImage.createGraphics();
                component.paint((Graphics)object);
                ((Graphics)object).dispose();
            }
            if (bufferedImage != null && (d = Math.min(this.max.getWidth() / dimension.getWidth(), this.max.getHeight() / dimension.getHeight())) < 1.0) {
                int n = (int)(d * dimension.getWidth());
                int n2 = (int)(d * dimension.getHeight());
                n = Math.max(n, 1);
                n2 = Math.max(n2, 1);
                if (n != dimension.width || n2 != dimension.height) {
                    BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, dimension.width, dimension.height, null);
                    graphics2D.dispose();
                    bufferedImage = bufferedImage2;
                }
            }
        }
        if (bufferedImage == null) {
            object = dockable.getTitleIcon();
            if (object == null || object.getIconHeight() < 1 || object.getIconWidth() < 1) {
                return null;
            }
            bufferedImage = new BufferedImage(object.getIconWidth() + 2, object.getIconHeight() + 2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(component.getBackground());
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            object.paintIcon(component, graphics2D, 1, 1);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public MovingImage create(DockController dockController, Dockable dockable) {
        BufferedImage bufferedImage = this.createImageFrom(dockController, dockable);
        TrueMovingImage trueMovingImage = new TrueMovingImage();
        trueMovingImage.setImage(bufferedImage);
        return trueMovingImage;
    }
}

