/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.focus;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.focus.AbstractDockableSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultDockableSelection
extends AbstractDockableSelection {
    private Model model = new Model();
    private JScrollPane listPane;
    private JList list = new JList(this.model);

    public DefaultDockableSelection() {
        this.list.setCellRenderer(new Renderer());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultDockableSelection.this.setSelection((Dockable)DefaultDockableSelection.this.list.getSelectedValue());
            }
        });
        this.setLayout(new BorderLayout());
        this.listPane = new JScrollPane(this.list);
        this.add((Component)this.listPane, "Center");
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DefaultDockableSelection.this.select();
            }
        });
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = DefaultDockableSelection.this.list.getSelectedIndex();
                int n2 = DefaultDockableSelection.this.list.locationToIndex(mouseEvent.getPoint());
                if (n2 != n && n2 >= 0 && n2 < DefaultDockableSelection.this.model.getSize()) {
                    DefaultDockableSelection.this.list.setSelectedIndex(n2);
                }
            }
        });
    }

    public void updateUI() {
        super.updateUI();
        if (this.list != null) {
            this.list.setCellRenderer(new Renderer());
        }
    }

    protected JComponent getList() {
        return this.listPane;
    }

    protected void up() {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            n = 0;
        } else if (--n < 0) {
            n = this.model.getSize() - 1;
        }
        this.list.setSelectedIndex(n);
        this.list.ensureIndexIsVisible(n);
    }

    protected void right() {
        this.down();
    }

    protected void down() {
        int n = this.list.getSelectedIndex();
        if (++n >= this.model.getSize()) {
            n = 0;
        }
        this.list.setSelectedIndex(n);
        this.list.ensureIndexIsVisible(n);
    }

    protected void left() {
        this.up();
    }

    protected void iconChanged(int n, Dockable dockable) {
        this.model.change(n);
    }

    protected void insert(int n, Dockable dockable) {
        this.model.insertElementAt(dockable, n);
    }

    protected void remove(int n, Dockable dockable) {
        this.model.remove(n);
    }

    protected void select(Dockable dockable) {
        this.list.setSelectedValue(dockable, true);
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void titleChanged(int n, Dockable dockable) {
        this.model.change(n);
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Dockable) {
                Dockable dockable = (Dockable)object;
                super.getListCellRendererComponent((JList<?>)jList, "", n, bl, bl2);
                this.setText(dockable.getTitleText());
                this.setIcon(dockable.getTitleIcon());
                return this;
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private static class Model
    extends DefaultListModel {
        private Model() {
        }

        public void change(int n) {
            this.fireContentsChanged(this, n, n);
        }
    }
}

