/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockStationLayout;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockStationFactory
implements DockFactory<SplitDockStation, SplitDockStationLayout> {
    public static final String ID = "SplitDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public SplitDockStationLayout getLayout(final SplitDockStation splitDockStation, final Map<Dockable, Integer> map) {
        SplitDockStationLayout.Entry entry = splitDockStation.visit(new SplitTreeFactory<SplitDockStationLayout.Entry>(){
            private PlaceholderStrategy strategy;
            {
                this.strategy = splitDockStation.getPlaceholderStrategy();
            }

            @Override
            public SplitDockStationLayout.Entry leaf(Dockable dockable, long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                Integer n = (Integer)map.get(dockable);
                pathArray = DockUtilities.mergePlaceholders(pathArray, dockable, this.strategy);
                if (n != null) {
                    return new SplitDockStationLayout.Leaf(n, pathArray, placeholderMap, l);
                }
                if (pathArray != null && pathArray.length > 0) {
                    return new SplitDockStationLayout.Leaf(-1, pathArray, placeholderMap, l);
                }
                return null;
            }

            @Override
            public SplitDockStationLayout.Entry placeholder(long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                if (pathArray != null && pathArray.length > 0) {
                    return new SplitDockStationLayout.Leaf(-1, pathArray, placeholderMap, l);
                }
                return null;
            }

            @Override
            public SplitDockStationLayout.Entry root(SplitDockStationLayout.Entry entry, long l) {
                return entry;
            }

            @Override
            public SplitDockStationLayout.Entry horizontal(SplitDockStationLayout.Entry entry, SplitDockStationLayout.Entry entry2, double d, long l, Path[] pathArray, PlaceholderMap placeholderMap, boolean bl) {
                if (entry == null) {
                    return entry2;
                }
                if (entry2 == null) {
                    return entry;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.HORIZONTAL, d, entry, entry2, pathArray, placeholderMap, l);
            }

            @Override
            public SplitDockStationLayout.Entry vertical(SplitDockStationLayout.Entry entry, SplitDockStationLayout.Entry entry2, double d, long l, Path[] pathArray, PlaceholderMap placeholderMap, boolean bl) {
                if (entry == null) {
                    return entry2;
                }
                if (entry2 == null) {
                    return entry;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.VERTICAL, d, entry, entry2, pathArray, placeholderMap, l);
            }
        });
        Dockable dockable = splitDockStation.getFullScreen();
        Integer n = null;
        if (dockable != null) {
            n = map.get(dockable);
        }
        if (n == null) {
            return new SplitDockStationLayout(entry, -1);
        }
        return new SplitDockStationLayout(entry, n);
    }

    @Override
    public void setLayout(SplitDockStation splitDockStation, SplitDockStationLayout splitDockStationLayout, Map<Integer, Dockable> map) {
        SplitDockTree splitDockTree = new SplitDockTree();
        SplitDockTree.Key key = null;
        if (splitDockStationLayout.getRoot() != null) {
            key = this.handleEntry(splitDockStationLayout.getRoot(), splitDockTree, map);
        }
        if (key != null) {
            splitDockTree.root(key);
        }
        splitDockStation.dropTree(splitDockTree, false);
        Dockable dockable = map.get(splitDockStationLayout.getFullscreen());
        splitDockStation.setFullScreen(dockable);
    }

    private SplitDockTree.Key handleEntry(SplitDockStationLayout.Entry entry, SplitDockTree splitDockTree, Map<Integer, Dockable> map) {
        if (entry.asLeaf() != null) {
            return this.handleLeaf(entry.asLeaf(), splitDockTree, map);
        }
        return this.handleNode(entry.asNode(), splitDockTree, map);
    }

    private SplitDockTree.Key handleLeaf(SplitDockStationLayout.Leaf leaf, SplitDockTree splitDockTree, Map<Integer, Dockable> map) {
        Dockable dockable = map.get(leaf.getId());
        Path[] pathArray = leaf.getPlaceholders();
        PlaceholderMap placeholderMap = leaf.getPlaceholderMap();
        if (dockable != null) {
            return splitDockTree.put(new Dockable[]{dockable}, null, pathArray, placeholderMap, leaf.getNodeId());
        }
        if (pathArray != null && pathArray.length > 0) {
            return splitDockTree.put(new Dockable[0], null, pathArray, placeholderMap, leaf.getNodeId());
        }
        return null;
    }

    private SplitDockTree.Key handleNode(SplitDockStationLayout.Node node, SplitDockTree splitDockTree, Map<Integer, Dockable> map) {
        SplitDockTree.Key key = this.handleEntry(node.getChildA(), splitDockTree, map);
        SplitDockTree.Key key2 = this.handleEntry(node.getChildB(), splitDockTree, map);
        if (key == null) {
            return key2;
        }
        if (key2 == null) {
            return key;
        }
        switch (node.getOrientation()) {
            case HORIZONTAL: {
                return splitDockTree.horizontal(key, key2, node.getDivider(), node.getPlaceholders(), node.getPlaceholderMap(), node.getNodeId());
            }
            case VERTICAL: {
                return splitDockTree.vertical(key, key2, node.getDivider(), node.getPlaceholders(), node.getPlaceholderMap(), node.getNodeId());
            }
        }
        return null;
    }

    @Override
    public void estimateLocations(SplitDockStationLayout splitDockStationLayout, LocationEstimationMap locationEstimationMap) {
        this.estimateLocations(splitDockStationLayout.getRoot(), locationEstimationMap);
    }

    @Override
    private void estimateLocations(SplitDockStationLayout.Entry entry, LocationEstimationMap locationEstimationMap) {
        Object object;
        if (entry == null) {
            return;
        }
        SplitDockStationLayout.Leaf leaf = entry.asLeaf();
        if (leaf != null && (object = locationEstimationMap.getChild(leaf.getId())) != null) {
            SplitDockPathProperty splitDockPathProperty = leaf.createPathProperty();
            Path path = ((DockLayoutInfo)object).getPlaceholder();
            if (path != null) {
                ((DockLayoutInfo)object).setLocation(new SplitDockPlaceholderProperty(path, splitDockPathProperty));
            } else {
                ((DockLayoutInfo)object).setLocation(splitDockPathProperty);
            }
            int n = locationEstimationMap.getSubChildCount(leaf.getId());
            for (int i = 0; i < n; ++i) {
                DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(leaf.getId(), i);
                path = dockLayoutInfo.getPlaceholder();
                if (path == null) continue;
                dockLayoutInfo.setLocation(new SplitDockPlaceholderProperty(path, splitDockPathProperty));
            }
        }
        if ((object = entry.asNode()) != null) {
            this.estimateLocations(((SplitDockStationLayout.Node)object).getChildA(), locationEstimationMap);
            this.estimateLocations(((SplitDockStationLayout.Node)object).getChildB(), locationEstimationMap);
        }
    }

    @Override
    public void setLayout(SplitDockStation splitDockStation, SplitDockStationLayout splitDockStationLayout) {
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout splitDockStationLayout) {
        SplitDockStation splitDockStation = this.createStation();
        this.setLayout(splitDockStation, splitDockStationLayout);
        return splitDockStation;
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout splitDockStationLayout, Map<Integer, Dockable> map) {
        SplitDockStation splitDockStation = this.createStation();
        this.setLayout(splitDockStation, splitDockStationLayout, map);
        return splitDockStation;
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8a);
        SplitDockStationLayout.Entry entry = splitDockStationLayout.getRoot();
        if (entry == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            this.writeEntry(entry, dataOutputStream);
        }
        dataOutputStream.writeInt(splitDockStationLayout.getFullscreen());
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(entry.getNodeId());
        Path[] pathArray = entry.getPlaceholders();
        PlaceholderMap placeholderMap = entry.getPlaceholderMap();
        int n = 0;
        if (entry.asNode() != null) {
            n |= 1;
        }
        if (pathArray != null && pathArray.length > 0) {
            n |= 2;
        }
        if (placeholderMap != null) {
            n |= 4;
        }
        dataOutputStream.writeByte(n);
        if (pathArray != null && pathArray.length > 0) {
            dataOutputStream.writeInt(pathArray.length);
            for (Path path : pathArray) {
                dataOutputStream.writeUTF(path.toString());
            }
        }
        if (placeholderMap != null) {
            placeholderMap.write(dataOutputStream);
        }
        if (entry.asLeaf() != null) {
            dataOutputStream.writeInt(entry.asLeaf().getId());
        } else {
            Path[] pathArray2 = entry.asNode();
            dataOutputStream.writeInt(pathArray2.getOrientation().ordinal());
            dataOutputStream.writeDouble(pathArray2.getDivider());
            this.writeEntry(pathArray2.getChildA(), dataOutputStream);
            this.writeEntry(pathArray2.getChildB(), dataOutputStream);
        }
    }

    @Override
    public SplitDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        boolean bl2 = Version.VERSION_1_0_8a.compareTo(version) <= 0;
        SplitDockStationLayout.Entry entry = null;
        if (dataInputStream.readBoolean()) {
            entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
        }
        int n = dataInputStream.readInt();
        return new SplitDockStationLayout(entry, n);
    }

    private SplitDockStationLayout.Entry readEntry(DataInputStream dataInputStream, boolean bl, boolean bl2, PlaceholderStrategy placeholderStrategy) throws IOException {
        long l = -1L;
        if (bl) {
            l = dataInputStream.readLong();
        }
        if (bl2) {
            byte by = dataInputStream.readByte();
            boolean bl3 = (by & 1) != 0;
            boolean bl4 = (by & 2) != 0;
            boolean bl5 = (by & 4) != 0;
            Path[] pathArray = null;
            if (bl4) {
                pathArray = new Path[dataInputStream.readInt()];
                for (int i = 0; i < pathArray.length; ++i) {
                    pathArray[i] = new Path(dataInputStream.readUTF());
                }
            }
            PlaceholderMap placeholderMap = null;
            if (bl5) {
                placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
                placeholderMap.setPlaceholderStrategy(null);
            }
            if (bl3) {
                SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[dataInputStream.readInt()];
                double d = dataInputStream.readDouble();
                SplitDockStationLayout.Entry entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
                SplitDockStationLayout.Entry entry2 = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
                return new SplitDockStationLayout.Node(orientation, d, entry, entry2, pathArray, placeholderMap, l);
            }
            return new SplitDockStationLayout.Leaf(dataInputStream.readInt(), pathArray, placeholderMap, l);
        }
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return new SplitDockStationLayout.Leaf(dataInputStream.readInt(), null, null, l);
        }
        if (by == 1) {
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[dataInputStream.readInt()];
            double d = dataInputStream.readDouble();
            SplitDockStationLayout.Entry entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            SplitDockStationLayout.Entry entry3 = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            return new SplitDockStationLayout.Node(orientation, d, entry, entry3, null, null, l);
        }
        if (by == 2) {
            int n = dataInputStream.readInt();
            Path[] pathArray = this.readPlaceholders(dataInputStream, placeholderStrategy);
            return new SplitDockStationLayout.Leaf(n, pathArray, null, l);
        }
        if (by == 3) {
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[dataInputStream.readInt()];
            double d = dataInputStream.readDouble();
            Path[] pathArray = this.readPlaceholders(dataInputStream, placeholderStrategy);
            SplitDockStationLayout.Entry entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            SplitDockStationLayout.Entry entry4 = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            return new SplitDockStationLayout.Node(orientation, d, entry, entry4, pathArray, null, l);
        }
        throw new IOException("unknown kind: " + by);
    }

    private Path[] readPlaceholders(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        int n = dataInputStream.readInt();
        ArrayList<Path> arrayList = new ArrayList<Path>(n);
        for (int i = 0; i < n; ++i) {
            Path path = new Path(dataInputStream.readUTF());
            if (placeholderStrategy != null && !placeholderStrategy.isValidPlaceholder(path)) continue;
            arrayList.add(path);
        }
        return arrayList.toArray(new Path[arrayList.size()]);
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, XElement xElement) {
        if (splitDockStationLayout.getFullscreen() != -1) {
            xElement.addElement("fullscreen").addInt("id", splitDockStationLayout.getFullscreen());
        }
        if (splitDockStationLayout.getRoot() != null) {
            this.writeEntry(splitDockStationLayout.getRoot(), xElement);
        }
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, XElement xElement) {
        Object object;
        XElement xElement2;
        if (entry.asLeaf() != null) {
            xElement2 = xElement.addElement("leaf");
            xElement2.addInt("id", entry.asLeaf().getId()).addLong("nodeId", entry.getNodeId());
        } else {
            xElement2 = xElement.addElement("node");
            xElement2.addLong("nodeId", entry.getNodeId());
            xElement2.addString("orientation", entry.asNode().getOrientation().name());
            xElement2.addDouble("divider", entry.asNode().getDivider());
            this.writeEntry(entry.asNode().getChildA(), xElement2);
            this.writeEntry(entry.asNode().getChildB(), xElement2);
        }
        Path[] pathArray = entry.getPlaceholders();
        if (pathArray != null && pathArray.length > 0) {
            object = xElement2.addElement("placeholders");
            for (Path path : pathArray) {
                ((XElement)object).addElement("placeholder").setString(path.toString());
            }
        }
        if ((object = entry.getPlaceholderMap()) != null) {
            XElement xElement3 = xElement2.addElement("placeholder-map");
            ((PlaceholderMap)object).write(xElement3);
        }
    }

    @Override
    public SplitDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        SplitDockStationLayout.Entry entry = null;
        XElement xElement2 = xElement.getElement("node");
        if (xElement2 == null) {
            xElement2 = xElement.getElement("leaf");
        }
        if (xElement2 != null) {
            entry = this.readEntry(xElement2, placeholderStrategy);
        }
        int n = -1;
        XElement xElement3 = xElement.getElement("fullscreen");
        if (xElement3 != null) {
            n = xElement3.getInt("id");
        }
        return new SplitDockStationLayout(entry, n);
    }

    private SplitDockStationLayout.Entry readEntry(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        Iterable<XElement> iterable;
        Object object;
        long l = -1L;
        if (xElement.attributeExists("nodeId")) {
            l = xElement.getLong("nodeId");
        }
        Path[] pathArray = null;
        XElement xElement2 = xElement.getElement("placeholders");
        if (xElement2 != null && ((XElement[])(object = xElement2.getElements("placeholder"))).length > 0) {
            iterable = new ArrayList(((XElement[])object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Path path = new Path(((XElement)object[i]).getString());
                if (placeholderStrategy != null && !placeholderStrategy.isValidPlaceholder(path)) continue;
                iterable.add((Path)path);
            }
            pathArray = iterable.toArray((Path[])new Path[iterable.size()]);
        }
        object = null;
        iterable = xElement.getElement("placeholder-map");
        if (iterable != null) {
            object = new PlaceholderMap((XElement)iterable, placeholderStrategy);
            ((PlaceholderMap)object).setPlaceholderStrategy(null);
        }
        if ("leaf".equals(xElement.getName())) {
            return new SplitDockStationLayout.Leaf(xElement.getInt("id"), pathArray, (PlaceholderMap)object, l);
        }
        if ("node".equals(xElement.getName())) {
            XElement[] xElementArray = xElement.getElements("leaf", "node");
            if (xElementArray.length != 2) {
                throw new XException("node element must have exactly least two children: " + xElement);
            }
            return new SplitDockStationLayout.Node(SplitDockStation.Orientation.valueOf(xElement.getString("orientation")), xElement.getDouble("divider"), this.readEntry(xElementArray[0], placeholderStrategy), this.readEntry(xElementArray[1], placeholderStrategy), pathArray, (PlaceholderMap)object, l);
        }
        throw new XException("element neither leaf nor node: " + xElement);
    }

    protected SplitDockStation createStation() {
        return new SplitDockStation();
    }
}

