/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTabLayoutManager<I extends PaneInfo>
implements TabLayoutManager {
    private List<I> infos = new ArrayList<I>();

    @Override
    public void install(TabPane tabPane) {
        I i = this.createInfoFor(tabPane);
        tabPane.addTabPaneListener((TabPaneListener)i);
        this.infos.add(i);
    }

    @Override
    public void uninstall(TabPane tabPane) {
        ListIterator<I> listIterator = this.infos.listIterator();
        while (listIterator.hasNext()) {
            PaneInfo paneInfo = (PaneInfo)listIterator.next();
            if (paneInfo.getPane() != tabPane) continue;
            listIterator.remove();
            tabPane.removeTabPaneListener(paneInfo);
            this.destroy(paneInfo);
        }
    }

    protected abstract I createInfoFor(TabPane var1);

    protected abstract void destroy(I var1);

    public I getInfo(TabPane tabPane) {
        for (PaneInfo paneInfo : this.infos) {
            if (paneInfo.getPane() != tabPane) continue;
            return (I)paneInfo;
        }
        return null;
    }

    protected static class PaneInfo
    implements TabPaneListener {
        private TabPane pane;

        public PaneInfo(TabPane tabPane) {
            if (tabPane == null) {
                throw new IllegalStateException("pane must not be null");
            }
            this.pane = tabPane;
        }

        public TabPane getPane() {
            return this.pane;
        }

        public void added(TabPane tabPane, Dockable dockable) {
        }

        public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
        }

        public void removed(TabPane tabPane, Dockable dockable) {
        }

        public void selectionChanged(TabPane tabPane) {
        }
    }
}

